% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\docType{class}
\name{slm-class}
\alias{slm-class}
\alias{slm.class}
\title{slm class}
\description{
An S4 class to create an \code{slm} object.
}
\section{Slots}{

\describe{
\item{\code{method_cov_st}}{the method used to compute the autocovariance vector of the error process.}

\item{\code{cov_st}}{a numeric vector with the estimated autocovariances of the error process, computed from
the \code{method_cov_st} method.}

\item{\code{Cov_ST}}{the estimated covariance matrix of the error process, computed from the \code{method_cov_st} method.}

\item{\code{model_selec}}{the order of the chosen method. If \code{model_selec = -1}, the method works automatically.}

\item{\code{norm_matrix}}{the normalization matrix of the design X.}

\item{\code{design_qr}}{the matrix \eqn{(X^{t} X)^{-1}}.}
}}

\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
