\name{stat.Chen}
\alias{stat.Chen}

\title{Apply Chen's single slide method}

\description{
Applies Chens single slide method. 
}


\usage{
stat.Chen(RG,layout,norm="p",image.id=1,pout=TRUE)
}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix and the grid
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{image.id}{Specifies image to which Chen's method will be applied.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

  \item{pout}{if TRUE, an M vs. A plot will be produced with limits due
    to Chen 95\% and 99\%. If FALSE, returns upper and lower bounds at
	       95\% and 99\% levels.}
    
}


\value{
  List containing the following components:

  \item{lower01}{The lower limit of 99\% confidence interval}
  \item{upper01}{The upper limit of 99\% confidence interval}
  \item{lower05}{The lower limit of 95\% confidence interval}
  \item{upper05}{The upper limit of 95\% confidence interval}

}

\references{
  Chen, Y., E.R. Dougherty, and M.L. Bittner. Ratio-based decisions and
  the quantitative analysis of cDNA microarray images. Journal of
  Biomedical Optics , Volume 2 (4), 364-374, 1997. (1997)

}


\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.ChurSap}},\code{\link{stat.Newton}}}

\examples{
data(MouseArray)
##mouse.setup <- init.grid() 
##mouse.data <- init.data() ## see \emph{init.data}
stat.Chen(mouse.data,mouse.setup,image.id=3)
}

\keyword{models}

%\keyword{microarray, Chen}





