\name{stat.ChurSap}
\alias{stat.ChurSap}


\title{Apply Sapir and Churchills single slide method}

\description{
Applies Sapirs and Churchills single slide method. 
}


\usage{
stat.ChurSap(RG,layout,pp=0.95,norm="p", pout=T, image.id=1,...)

}

\arguments{
  \item{RG}{
    a list with 4 elements, each represents a matrix with p rows for p
    genes and n columns for n slides. \cr
    The first element "R" contains the raw red intensities from slide
    i=1,...,n .\cr
    Similarly, the second element "G" contains the raw green
    intensities. \cr
    The third element "Rb"  contains the background red intensities and \cr
    the fourth element "Gb" contains the  background green intensities.\cr
    This list structure can be generated by the interactive function
    \code{\link{init.data}}. }
  
  \item{layout}{a list specifying the dimensions of the spot matrix and the grid
    matrix.  This can be generated by calling \code{\link{init.grid}}.}

  \item{pp}{Posterior probability of being differentially
  expressed. Defaults to 0.95}
  
  \item{image.id}{Specifies image to which Chen's method will be applied.}

  \item{norm}{Character string, one of "n", "m", "l", "p" or "s".  This
    argument specifies the type of normalization method to be performed:
    "n" no normalization between the 2 channels; "m"
    \code{\link{median}} normalization, which sets the median of log
    intensity ratios to zero; "l" global \code{\link{lowess}}
    normalization; "p" print-tip group lowess normalization and "s"
    scaled print-tip group lowess normalization. The default method is
    set to print-tip normalization.}

  \item{pout}{if TRUE, an M vs. A plot will be produced with limits due
    to Churchill and Sapir at the specified posterior probability level. If FALSE, return a list with pertinant information}
  \item{\dots}{additional graphical parameters}
}


\value{
  List containing the following components:

  \item{limits}{the positive value of the limit at the posterior
  probability value of pp}
  \item{theta}{parameters estimated by EM algorithm, specifically a
    mixing proportion and a variance}
  \item{pp}{Posterior probabilities of being differentially expressed
  given observed data for each gene.}

}

\references{
  Sapir and Churchill(2000), Estimating the posterior probability of
  differential gene expression from microarray data . \url{http://www.jax.org/research/churchill/}
}

\author{
  Ben Bolstad, \email{bolstad@stat.berkeley.edu}
}

\seealso{\code{\link{stat.Chen}},\code{\link{stat.Newton}}}

\examples{
data(MouseArray)
##mouse.setup <- init.grid() 
##mouse.data <- init.data() ## see \emph{init.data}
stat.ChurSap(mouse.data,mouse.setup,pp=0.95,image.id=3)
}

%\keyword{microarray, Churchill, Sapir}
\keyword{models}