% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{estimate}
\alias{estimate}
\alias{estimate.smam_mrme}
\alias{estimate.smam_mr}
\alias{estimate.smam_mm}
\alias{estimate.smam_mrh}
\alias{estimate.smam_bmme}
\title{Estimate Result of smam Estimators}
\usage{
estimate(x, ...)

\method{estimate}{smam_mrme}(x, ...)

\method{estimate}{smam_mr}(x, ...)

\method{estimate}{smam_mm}(x, ...)

\method{estimate}{smam_mrh}(x, ...)

\method{estimate}{smam_bmme}(x, ...)
}
\arguments{
\item{x}{a fitted object from one of `smam::fitXXXX` functions}

\item{...}{other arguments}
}
\description{
`estimate` function returns the estimate result
of `smam::fitXXXX` from smam package.
}
\examples{
## time consuming example
#tgrid <- seq(0, 100, length=100)
#set.seed(123)
#dat <- rMRME(tgrid, 1, 0.5, 1, 0.01, "m")

## fit whole dataset to the MRME model
#fit <- fitMRME(dat, start=c(1, 0.5, 1, 0.01))
#fit

## get covariance matrix of estimators
#estimate(fit)

}
