% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{discretize}
\alias{discretize}
\title{Discretization wrapper}
\usage{
discretize(dataset, method, class_attr = NULL, exclude = NULL, ...)
}
\arguments{
\item{dataset}{we want to perform discretization on}

\item{method}{selected method of discretization}

\item{class_attr}{\code{character}. Indicates the class attribute or
attributes from \code{dataset}. Must exist in it.}

\item{exclude}{\code{character}. Vector of attributes to exclude from the
discretization}

\item{...}{Further arguments for \code{method}}
}
\value{
The discretized dataset
}
\description{
Discretization wrapper
}
\examples{
library("smartdata")

super_iris <- discretize(iris, method = "chi_merge",
                         class_attr = "Species", exclude = "Sepal.Length")
super_iris <- discretize(iris, method = "chi_merge",
                         class_attr = "Species", alpha = 0.7)
super_iris <- discretize(iris, method = "chi2", "Species",
                         alpha = 0.7, delta = 0.1)
super_iris <- discretize(iris, method = "chi2", class_attr = "Species")
super_iris <- discretize(iris, method = "extended_chi2", class_attr = "Species")
super_iris <- discretize(iris, method = "ameva", class_attr = "Species")
super_iris <- discretize(iris, method = "CAIM", class_attr = "Species")
super_iris <- discretize(iris, method = "CACC", class_attr = "Species")
super_iris <- discretize(iris, method = "equalwidth", num_bins = nrow(iris) / 2)
super_iris <- discretize(iris, method = "equalfreq", num_bins = nrow(iris) / 2)

}
