#ifndef SMCRYPTO_H
#define SMCRYPTO_H

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

typedef struct Keypair {
  char *private_key;
  char *public_key;
} Keypair;

typedef struct KeyExchangeData {
  unsigned char *data;
  char *private_key_r;
} KeyExchangeData;

typedef struct KeyExchangeResult {
  char *k;
  unsigned char *s12;
} KeyExchangeResult;

char *sm3_hash(const unsigned char *msg, size_t len);

char *sm3_hash_string(const char *msg_str);

char *sm3_hash_file(const char *file_path);

struct Keypair *gen_keypair(void);

char *pk_from_sk(const char *private_key);

int privkey_valid(const char *private_key);

int pubkey_valid(const char *public_key);

int hex_valid(const char *input);

int base64_valid(const char *input);

struct Keypair *keypair_from_pem_file(const char *pem_file);

void keypair_to_pem_file(const char *private_key, const char *pem_file);

char *pubkey_from_pem_file(const char *pem_file);

void pubkey_to_pem_file(const char *public_key, const char *pem_file);

unsigned char *sign(const unsigned char *id,
                    size_t id_len,
                    const unsigned char *data,
                    size_t data_len,
                    const char *private_key,
                    uintptr_t *sig_len);

int verify(const unsigned char *id,
           size_t id_len,
           const unsigned char *data,
           size_t data_len,
           const unsigned char *sign,
           size_t sign_len,
           const char *public_key);

void sign_to_file(const unsigned char *id,
                  size_t id_len,
                  const unsigned char *data,
                  size_t data_len,
                  const char *sign_file,
                  const char *private_key);

int verify_from_file(const unsigned char *id,
                     size_t id_len,
                     const unsigned char *data,
                     size_t data_len,
                     const char *sign_file,
                     const char *public_key);

unsigned char *encrypt(const unsigned char *data,
                       size_t data_len,
                       const char *public_key,
                       size_t *enc_len);

unsigned char *decrypt(const unsigned char *data,
                       size_t data_len,
                       const char *private_key,
                       size_t *dec_len);

unsigned char *encrypt_c1c2c3(const unsigned char *data,
                              size_t data_len,
                              const char *public_key,
                              size_t *enc_len);

unsigned char *decrypt_c1c2c3(const unsigned char *data,
                              size_t data_len,
                              const char *private_key,
                              size_t *dec_len);

unsigned char *encrypt_asna1(const unsigned char *data,
                             size_t data_len,
                             const char *public_key,
                             size_t *enc_len);

unsigned char *decrypt_asna1(const unsigned char *data,
                             size_t data_len,
                             const char *private_key,
                             size_t *dec_len);

char *encrypt_hex(const unsigned char *data, size_t data_len, const char *public_key);

unsigned char *decrypt_hex(const char *data, const char *private_key, size_t *dec_len);

char *encrypt_base64(const unsigned char *data, size_t data_len, const char *public_key);

unsigned char *decrypt_base64(const char *data, const char *private_key, size_t *dec_len);

void encrypt_to_file(const unsigned char *data,
                     size_t data_len,
                     const char *enc_file,
                     const char *public_key);

unsigned char *decrypt_from_file(const char *dec_file, const char *private_key, size_t *dec_len);

struct KeyExchangeData *keyexchange_1ab(size_t klen,
                                        const unsigned char *id,
                                        uintptr_t id_len,
                                        const char *private_key,
                                        size_t *data_len);

struct KeyExchangeResult *keyexchange_2a(const unsigned char *id,
                                         uintptr_t id_len,
                                         const char *private_key,
                                         const char *private_key_r,
                                         const unsigned char *recive_bytes,
                                         uintptr_t recive_bytes_len,
                                         size_t *s12_len);

struct KeyExchangeResult *keyexchange_2b(const unsigned char *id,
                                         uintptr_t id_len,
                                         const char *private_key,
                                         const char *private_key_r,
                                         const unsigned char *recive_bytes,
                                         uintptr_t recive_bytes_len,
                                         size_t *s12_len);

unsigned char *encrypt_ecb(const unsigned char *input_data,
                           size_t input_date_len,
                           const unsigned char *key,
                           size_t key_len,
                           size_t *output_data_len);

char *encrypt_ecb_base64(const unsigned char *input_data,
                         size_t input_date_len,
                         const unsigned char *key,
                         size_t key_len);

char *encrypt_ecb_hex(const unsigned char *input_data,
                      size_t input_date_len,
                      const unsigned char *key,
                      size_t key_len);

void encrypt_ecb_to_file(const char *input_file,
                         const char *output_file,
                         const unsigned char *key,
                         size_t key_len);

unsigned char *decrypt_ecb(const unsigned char *input_data,
                           size_t input_date_len,
                           const unsigned char *key,
                           size_t key_len,
                           size_t *output_data_len);

unsigned char *decrypt_ecb_base64(const char *input_data,
                                  const unsigned char *key,
                                  size_t key_len,
                                  size_t *output_data_len);

unsigned char *decrypt_ecb_hex(const char *input_data,
                               const unsigned char *key,
                               size_t key_len,
                               size_t *output_data_len);

void decrypt_ecb_from_file(const char *input_file,
                           const char *output_file,
                           const unsigned char *key,
                           size_t key_len);

unsigned char *encrypt_cbc(const unsigned char *input_data,
                           size_t input_data_len,
                           const unsigned char *key,
                           size_t key_len,
                           const unsigned char *iv,
                           size_t iv_len,
                           size_t *output_data_len);

char *encrypt_cbc_base64(const unsigned char *input_data,
                         size_t input_data_len,
                         const unsigned char *key,
                         size_t key_len,
                         const unsigned char *iv,
                         size_t iv_len);

char *encrypt_cbc_hex(const unsigned char *input_data,
                      size_t input_data_len,
                      const unsigned char *key,
                      size_t key_len,
                      const unsigned char *iv,
                      size_t iv_len);

void encrypt_cbc_to_file(const char *input_file,
                         const char *output_file,
                         const unsigned char *key,
                         size_t key_len,
                         const unsigned char *iv,
                         size_t iv_len);

unsigned char *decrypt_cbc(const unsigned char *input_data,
                           size_t input_data_len,
                           const unsigned char *key,
                           size_t key_len,
                           const unsigned char *iv,
                           size_t iv_len,
                           size_t *output_data_len);

unsigned char *decrypt_cbc_base64(const char *input_data,
                                  const unsigned char *key,
                                  size_t key_len,
                                  const unsigned char *iv,
                                  size_t iv_len,
                                  size_t *output_data_len);

unsigned char *decrypt_cbc_hex(const char *input_data,
                               const unsigned char *key,
                               size_t key_len,
                               const unsigned char *iv,
                               size_t iv_len,
                               size_t *output_data_len);

void decrypt_cbc_from_file(const char *input_file,
                           const char *output_file,
                           const unsigned char *key,
                           size_t key_len,
                           const unsigned char *iv,
                           size_t iv_len);

void free_byte_array(unsigned char *ptr, size_t len);

void free_char_array(char *ptr);

void free_struct_keypair(struct Keypair *ptr);

void free_struct_keyexchangedata(struct KeyExchangeData *ptr);

void free_struct_keyexchangeresult(struct KeyExchangeResult *ptr);

#endif /* SMCRYPTO_H */
