% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.zones.R
\name{flex.zones}
\alias{flex.zones}
\title{Determine zones for flexibly shaped spatial scan test}
\usage{
flex.zones(coords, w, k = 10, lonlat = FALSE, parallel = TRUE)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid coordinates for the regions.}

\item{w}{A binary spatial adjacency matrix.}

\item{k}{An integer indicating the maximum number of regions to inclue in a potential cluster.  Default is 10}

\item{lonlat}{The default is \code{FALSE}, which specifies that Euclidean distance should be used.If \code{lonlat} is \code{TRUE}, then the great circle distance is used to calculate the intercentroid distance.}

\item{parallel}{A logical indicating whether the test should be parallelized using the \code{parallel::mclapply function}.  Default is \code{TRUE}.  If \code{TRUE}, no progress will be reported.}
}
\value{
Returns a list of zones to consider for clustering.  Each element of the list contains a vector with the location ids of the regions in that zone.
}
\description{
\code{flex.zones} determines the unique zones to consider for the flexibly shaped spatial scan test of Tango and Takahashi (2005).  The algorithm uses a breadth-first search to find all subgraphs connected to each vertex (region) in the data set of size \eqn{k} or less.
}
\examples{
data(nydf)
data(nyw)
coords = cbind(nydf$longitude, nydf$latitude)
flex.zones(coords = coords, w = nyw, k = 3, lonlat = TRUE)

}
\references{
Tango, T., & Takahashi, K. (2005). A flexibly shaped spatial scan statistic for detecting clusters. International journal of health geographics, 4(1), 11.
}
\author{
Joshua French
}
