% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmst.sim.R
\name{dmst.sim}
\alias{dmst.sim}
\title{Perform \code{dmst.test} on simulated data}
\usage{
dmst.sim(nsim = 1, nn, ty, ex, w, pop, max_pop, cl = NULL)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{nn}{A list of distance-based nearest neighbors,
preferably from the \code{\link{nndist}} function.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{pop}{The population size associated with each
region.}

\item{max_pop}{The population upperbound (in total
population) for a candidate zone.}

\item{cl}{
A cluster object created by \code{\link[parallel]{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{dmst.sim} efficiently performs
\code{\link{dmst.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{dmst.test}} function, but is informative for
better understanding the implementation of the test.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(longitude, latitude))
cases = floor(nydf$cases)
pop = nydf$pop
ty = sum(cases)
ex = ty/sum(pop) * pop
d = sp::spDists(coords, longlat = TRUE)
nn = nndist(d, ubd = 0.05)
max_pop = sum(pop) * 0.25
tsim = dmst.sim(1, nn, ty, ex, nyw, pop = pop,
                max_pop = max_pop)
}
