% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GridData.R
\name{apply_Grid}
\alias{apply_Grid}
\title{Apply a function to a \code{Grid} object.}
\usage{
apply_Grid(object, fun, ...)
}
\arguments{
\item{object}{An object with S4 class \code{"Grid"}}

\item{fun}{The function to be applied.}

\item{...}{Further arguments to be passed to \code{fun}.}
}
\value{
A vector of values.
}
\description{
Apply a function to a \code{Grid} object.
}
\details{
The function is applied to each vector combination of the levels by first
using the \code{as.matrix} coercion.
}
\note{
The result values are given in the order specified by the
\code{Grid} object.
}
\examples{
myGD <- Grid(levels = list("X" = c(0, 1),
                           "Y" = c(0.0, 0.5, 1.0),
                           "Z" = c(0.0, 0.2, 0.4, 1.0)))
## gaussian function
apply_Grid(myGD, fun = function(x) exp(-x[1]^2 - 3 * x[2]^2 - 2 * x[3]^2))
}
\seealso{
\code{\link{array_Grid}} to reshape the result as an array.
}

