% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{covar}
\alias{covar}
\alias{covar.smooth}
\title{Function returns the covariance matrix of conditional multiple steps ahead forecast errors}
\usage{
covar(object, type = c("analytical", "empirical", "simulated"), ...)

\method{covar}{smooth}(object, type = c("analytical", "empirical",
  "simulated"), ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{type}{What method to use in order to produce covariance matrix:
\enumerate{
\item \code{analytical} - based on the state space structure of the model and the
one-step-ahead forecast error. This works for pure additive and pure multiplicative
models. The values for the mixed models might be off.
\item \code{empirical} - based on the in-sample 1 to h steps ahead forecast errors
(works fine on larger samples);
\item \code{simulated} - the data is simulated from the estimated model, then the
same model is applied to it and then the empirical 1 to h steps ahead forecast
errors are produced;
}}

\item{...}{Other parameters passed to simulate function (if \code{type="simulated"}
is used). These are \code{obs}, \code{nsim} and \code{seed}. By default
\code{obs=1000}, \code{nsim=100}. This approach increases the accuracy of
covariance matrix on small samples and intermittent data;}
}
\value{
Scalar in cases of non-smooth functions. (h x h) matrix otherwise.
}
\description{
This function extracts covariance matrix of 1 to h steps ahead forecast errors for
\code{ssarima()}, \code{ges()}, \code{sma()}, \code{es()} and \code{ces()} models.
}
\details{
The function returns either scalar (if it is a non-smooth model)
or the matrix of (h x h) size with variances and covariances of 1 to h steps ahead
forecast errors. This is currently done based on empirical values. The analytical ones
are more complicated.
}
\examples{

x <- rnorm(100,0,1)

# A simple example with a 5x5 covariance matrix
ourModel <- ces(x, h=5)
covar(ourModel)

}
\seealso{
\link[smooth]{orders}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
