% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{forecast.smooth}
\alias{forecast.smooth}
\alias{forecast}
\alias{forecast.oes}
\title{Forecasting time series using smooth functions}
\usage{
\method{forecast}{smooth}(object, h = 10, interval = c("parametric",
  "semiparametric", "nonparametric", "none"), level = 0.95, ...)

\method{forecast}{oes}(object, h = 10, interval = c("parametric",
  "semiparametric", "nonparametric", "none"), level = 0.95, ...)
}
\arguments{
\item{object}{Time series model for which forecasts are required.}

\item{h}{Forecast horizon}

\item{interval}{Type of interval to construct. See \link[smooth]{es} for
details.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{...}{Other arguments accepted by either \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{gum} or \link[smooth]{ssarima}.}
}
\value{
Returns object of class "smooth.forecast", which contains:

\itemize{
\item \code{model} - the estimated model (ES / CES / GUM / SSARIMA).
\item \code{method} - the name of the estimated model (ES / CES / GUM / SSARIMA).
\item \code{fitted} - fitted values of the model.
\item \code{y} - actual values provided in the call of the model.
\item \code{forecast} aka \code{mean} - point forecasts of the model
(conditional mean).
\item \code{lower} - lower bound of prediction interval.
\item \code{upper} - upper bound of prediction interval.
\item \code{level} - confidence level.
\item \code{interval} - binary variable (whether interval were produced or not).
\item \code{residuals} - the residuals of the original model.
}
}
\description{
This function is created in order for the package to be compatible with Rob
Hyndman's "forecast" package
}
\details{
This is not a compulsory function. You can simply use \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{gum} or \link[smooth]{ssarima} without
\code{forecast.smooth}. But if you are really used to \code{forecast}
function, then go ahead!
}
\examples{

ourModel <- ces(rnorm(100,0,1),h=10)

forecast.smooth(ourModel,h=10)
forecast.smooth(ourModel,h=10,interval=TRUE)
plot(forecast.smooth(ourModel,h=10,interval=TRUE))

}
\references{
Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
}
\seealso{
\code{\link[forecast]{ets}, \link[forecast]{forecast}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ts}
\keyword{univar}
