% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{standardLasso}
\alias{standardLasso}
\title{Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the Lasso.}
\usage{
standardLasso(X, y, lambda)
}
\arguments{
\item{X}{The design matrix.}

\item{y}{The response vector.}

\item{lambda}{The Lasso regularization parameter.}
}
\value{
A list with six functions, precisely the objective \eqn{u}, penalty \eqn{v}, and dependence structure \eqn{w}, as well as their derivatives \eqn{du}, \eqn{dv}, and \eqn{dw}.
}
\description{
Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the Lasso.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
lambda <- 1
temp <- standardLasso(X,y,lambda)

}
\references{
Tibshirani, R. (1996). Regression Shrinkage and Selection Via the Lasso. J Roy Stat Soc B Met, 58(1):267-288.

Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
