% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_slope.R
\name{sm_slope}
\alias{sm_slope}
\title{A slope chart}
\usage{
sm_slope(
  ...,
  labels,
  group,
  line.params = list(color = "gray53", size = 0.4, alpha = 0.4),
  point.params = list(size = 2.5, shape = 21, color = "white"),
  avgLine.params = list(),
  avgPoint.params = list(),
  err.params = list(),
  xTick.params = list(position = "top", expand = c(0.17, 0.1), drop = FALSE),
  errorbar_type = "sd",
  many_groups = FALSE,
  show_err = FALSE,
  show_mean = FALSE,
  legends = FALSE
)
}
\arguments{
\item{...}{List of parameters for individual points and lines across different elements
(except for except for xTick.params), such as color, alpha, fill etc.}

\item{labels}{Labels for the ticks of the x-axis. This is a required argument.
It has to be a single vector containing either one
or multiple elements. ex: c('Day 1', 'Day 2')}

\item{group}{Name of the variable by which the individual data should be grouped}

\item{line.params}{List of parameters for the individual lines, such as color, alpha etc}

\item{point.params}{List of parameters for the individual points, such as color, alpha, fill etc}

\item{avgLine.params}{List of parameters for the average line, such as color, alpha etc}

\item{avgPoint.params}{List of parameters for the average point, such as color, alpha, fill etc}

\item{err.params}{List of parameters for the error bar from the average plot, such as color, alpha etc}

\item{xTick.params}{List of parameters for the x tick from the average plot, such as color, alpha etc}

\item{errorbar_type}{This argument determines the errorbar type.
If it is set to 'se', standard error bar will be shown.
If it is set to 'sd' (default), the error bar will display standard deviation.
If it is set to 'ci', the error bar will display 95\% confidence interval.}

\item{many_groups}{This argument determines whether the average line can be plotted for each group when
multiple groups are plotted at once.
If the average line needs to be plotted across all data presented, set this as FALSE.
If there are many groups that are presented and that each average line has to be plotted,
then set this as TRUE.}

\item{show_err}{If the error bar needs to be displayed, the input should be TRUE.
If the error bar is not needed, the input should be FALSE.}

\item{show_mean}{If the average plot needs to be displayed, the input should be TRUE.
If the average plot is not needed, the input should be FALSE.}

\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}
}
\value{
Returns a double vector output representing the slope from linear regression.
}
\description{
This function generates a slope chart.
This is very useful for comparing the effect between two time points.

For this function to work properly,
ggplot()'s mapping has to be quite specific.
1. Each observation has to be grouped.

With smplot2, average plot can be displayed along with error bars, both of which
are optional.
}
\examples{
library(ggplot2)
library(smplot2)

set.seed(1) # generate random data
day1 = rnorm(16,2,1)
day2 = rnorm(16,5,1)
Subject <- rep(paste0('S',seq(1:16)), 2)
Data <- data.frame(Value = matrix(c(day1,day2),ncol=1))
Day <- rep(c('Day 1', 'Day 2'), each = length(day1))
df <- cbind(Subject, Data, Day)

ggplot(data=df, aes(x = Day, y = Value, fill = Day)) +
 sm_slope(labels = c('Day 1', 'Day 2'), group = Subject) +
 scale_fill_manual(values=  sm_color('blue','orange'))
ggplot(data = df, aes(x = Day, y = Value, fill = Day)) +
 sm_slope(labels = c('Day 1','Day 2'),group = Subject,
          point.params = list(alpha = 0.3, size = 2.5, color = 'white',
                              shape = 21, fill = sm_color('skyblue')),
          line.params = list(color = sm_color('skyblue'),
                             alpha = 0.3),
          avgPoint.params = list(color='transparent', shape = 21,
                                 size = 4, fill = sm_color('blue')),
          avgLine.params = list(color = sm_color('blue'), size = 1),
          show_mean = TRUE)


}
