
############## 9. Calculate the significance of and plot the permuted ploygons ##############
## Calculate the significance of the observed area

#' Perm Plot
#'
#' perm_plot calculates the significance of the observed no-data zones and plots them relative to the simulations.
#'
#' @param perm a perm table generated by the perm_area() function.
#' @param n the sample size of the first vector
#' @param n2 the sample size of the second vector. Default is equal to n1.
#' @param histogram TRUE or FALSE. TRUE plots histograms while FALSE plots density plots.
#' @param method Default is "auto".
#'
#' @return a ggplot2 histogram and p-value for each no-data zone
#' @importFrom rlang .data
#' @export
#'
#' @examples
#' a = rnorm(100,0,1)
#' b = rnorm(100,0,1)
#' permExample = perm_area(a,b,10)
#' perm_plot(permExample, 100)
perm_plot = function(perm, n, n2 = n, histogram = TRUE, method = "auto") {
  
  nsim = length(perm[perm$polygon == "botr",2])

  botr_pos = perm[perm$polygon == "botr",2] >= perm[perm$source == "obs",2][[1]]
  # botr_perc = (sum(botr_pos) + 1) / (nsim + 1)
  botr_perc = statmod::permp(x = sum(botr_pos), nperm = nsim, n = n, n2 = n2, method = method)

  topl_pos = perm[perm$polygon == "topl",2] >= perm[perm$source == "obs",2][[2]]
  # topl_perc = (sum(topl_pos) + 1) / (nsim + 1)
  topl_perc = statmod::permp(x = sum(topl_pos), nperm = nsim, n = n, n2 = n2, method = method)

  topr_pos = perm[perm$polygon == "topr",2] >= perm[perm$source == "obs",2][[3]]
  # topr_perc = (sum(topr_pos) + 1) / (nsim + 1)
  topr_perc = statmod::permp(x = sum(topr_pos), nperm = nsim, n = n, n2 = n2, method = method)

  # Function to rename the facet headings
  poly_names = list('topl' = paste0("Upper left: p = ", round(topl_perc, 4)),
                    'topr' = paste0("Upper right: p = ", round(topr_perc, 4)),
                    'botr' = paste0("Lower right: p = ", round(botr_perc, 4)))

  poly_labeller <- function(variable,value){
    return(poly_names[value])
  }

  perm$polygon = factor(perm$polygon,
                        labels = c("botr", "topl", "topr"),
                        levels = c("topl", "topr", "botr"))
  OD = perm[perm$source == "obs",]

  if(histogram == F) {
    suppressWarnings(ggplot(data = perm, aes(x = .data$rescale, .data$..scaled..)) +
                       # geom_histogram(bins = 10, fill = "white", col = "darkgrey") +
                       geom_density(fill = "grey") +
                       geom_vline(aes(xintercept = .data$rescale), data = OD, col = "black", linetype = 2) +
                       facet_wrap( ~ polygon, scales = "free", labeller = poly_labeller) +
                       labs(x = "Relative area", y = "Scaled density",
                            title = paste0("Sample size: ", n, "\nRandom permutations: ",nsim - 1)) +
                       theme_bw()
    )
  } else {

    suppressWarnings(ggplot(data = perm, aes(x = .data$rescale)) +
                       geom_histogram(bins = 10, fill = "white", col = "darkgrey") +
                       geom_vline(aes(xintercept = .data$rescale), data = OD, col = "black", linetype = 2) +
                       facet_wrap( ~ polygon, scales = "free", labeller = poly_labeller) +
                       labs(x = "Relative area", y = "Frequency",
                            title = paste0("Sample size: ", n, "\nRandom permutations: ",nsim - 1)) +
                       theme_bw()
    )
  }
}
