% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_softmax5_template.R,
%   R/read_softmax6_template.R, R/read_softmax_template.R
\name{read_softmax5_template}
\alias{read_softmax5_template}
\alias{read_softmax6_template}
\alias{read_softmax_template}
\title{Read a 'SoftMax Pro' Template File}
\usage{
read_softmax5_template(file, include_unspecified = FALSE,
  zeropad_wells = FALSE, wellsAsFactors = TRUE, groupsAsFactors = TRUE,
  typesAsFactors = TRUE, encoding = "guess", ...)

read_softmax6_template(file, include_unspecified = FALSE,
  zeropad_wells = FALSE, wellsAsFactors = TRUE, groupsAsFactors = TRUE,
  typesAsFactors = TRUE, encoding = "guess", ...)

read_softmax_template(file, include_unspecified = FALSE,
  zeropad_wells = FALSE, wellsAsFactors = TRUE, groupsAsFactors = TRUE,
  typesAsFactors = TRUE, encoding = "guess", ...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector).}

\item{include_unspecified}{Logical value indicating whether (\code{TRUE}) or
not (\code{FALSE}) to include non-annotated wells (default: \code{FALSE})}

\item{zeropad_wells}{Logical value indicating whether or not well names should
be zero padded (e.g., "A04") (default: \code{FALSE})}

\item{wellsAsFactors}{Logical value indicating whether or not well names
(e.g., "H5") should be treated as factors (default: \code{TRUE})}

\item{groupsAsFactors}{Logical value indicating whether or not groups
should be treated as factors (default: \code{TRUE})}

\item{typesAsFactors}{Logical value indicating whether or not types
should be treated as factors (default: \code{TRUE}). The set of valid types
supported by 'SoftMax Pro' differs from version to version.}

\item{encoding}{Encoding for the template file. If \code{"guess"}, the
default, the encoding will be guessed.}

\item{...}{Additional parameters passed to \code{\link[utils]{read.delim}}}
}
\value{
A data frame
}
\description{
Read a 'SoftMax Pro' Template File
}
\note{
Different versions of 'SoftMax Pro' write units differently. For example,
v5.2 uses "l" for liters, while v6.4 uses "L".
}
\examples{
\dontrun{
t1 <- read_softmax_template("plate_template.txt")
}

}
