% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assoc.lib.R
\name{annotateSNPs}
\alias{annotateSNPs}
\title{Annotate SNPs}
\usage{
annotateSNPs(x, mode = c("significant", "top", "all"), alpha = 0.05,
  num.top = 10, capture.output = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{solarAssoc} or a character vector of SNPs.}

\item{mode}{A character with the mode of SNPs selection.
Possible values are \code{"significant"}, \code{"top"} and \code{"all"}.
The default value is \code{"significant"}.}

\item{alpha}{A numeric value from 0 to 1, the significance level after Bonferroni multiple-test correction.
Corresponds to \code{mode} equal to \code{"significant"}.}

\item{num.top}{An integer value, the number of top SNPs to be annotated.
Corresponds to \code{mode} equal to \code{"top"}.
The default value is 10.}

\item{capture.output}{Logical, indicates whether to capture the output from \code{AnnotateSNPList} function.
The default value is FALSE.}

\item{...}{Additional arguments.}
}
\value{
A data table with annotation results.
}
\description{
The function annotates SNPs based on \code{NCBI2R} R package,
in particular \code{AnnotateSNPList} function.
}
\details{
See \url{https://ncbi2r.wordpress.com/} for more details.
}

