% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{phenodata}
\alias{genocovdata}
\alias{genodata}
\alias{kin}
\alias{phenodata}
\alias{snpdata}
\title{dat50 data set adapted from FFBSKAT R package}
\format{(Phenotypes) A data frame \code{phenodata} with 66 rows and 4 variables:
\describe{
  \item{id}{Individual ID.}
  \item{sex}{Individual gender (0 - male, 1 - female).}
  \item{age}{Age.}
  \item{trait}{Simulated phenotype.}
}

(Kinship) A square matrix \code{kin} with 66 rows and 66 columns.

(Genotypes) A matrix \code{genodata} with 66 rows and 50 columns.

(Genotypes as covariates) A matrix \code{genocovdata} with 66 rows and 50 columns.

(Annotation) A data frame \code{snpdata} with 100 rows and 4 variables:
\describe{
  \item{name}{SNP name.}
  \item{chrom}{Chromosome.}
  \item{position}{Position in bp.}
  \item{gene}{Gene.}
}}
\source{
\url{http://mga.bionet.nsc.ru/soft/FFBSKAT/}
}
\usage{
phenodata

kin

genodata

genocovdata

snpdata
}
\description{
A mixture of unrelated and related individuals
were originally simulated in FFBSKAT R package to test methods of the variant-collapsing approach.
50 synthetic SNPs were generated for the association study.
A custom kinship matrix is used to express the relationships among individuals.
This data set is used here to test the ability of SOLAR
to work with a custom kinship matrix in both polygenic and association analyses.
}
\details{
The genotypes are coded in the format such as 1/1, 1/2 and 2/2.

In addition to the original data set from FFBSKAT R package,
a matrix of covariates was derived from the genotype data according to the additive model.
}
\examples{
data(dat50)

str(phenodata)
plotKinship2(2*kin)
str(genodata)

genodata[1:5, 1:5]
str(genocovdata)

genocovdata[1:5, 1:5]

# compare with the genotypes
genodata[1:5, 1:5]
str(snpdata)

head(snpdata)
}
\keyword{datasets}

