% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/solar.lib.R
\name{df2solar}
\alias{df2solar}
\title{Export phenotype and pedigree data into SOLAR files}
\usage{
df2solar(df, dir, kinship, kin2.gz = "kin2.gz", sort.ped = TRUE)
}
\arguments{
\item{df}{A data frame that containts both phenotype and pedigree data.}

\item{dir}{A character with path to a directory, where SOLAR files to be created.}

\item{kinship}{(optional) A kinship matrix to be exported.}

\item{kin2.gz}{A character with file name of SOLAR file to store the kinship matrix.}

\item{sort.ped}{Logical, indicating where pedigree IDs (FAM or FAMID) to be sorted.
   The default value is TRUE.}
}
\description{
The function exports phenotype and pedigree data from R to SOLAR.
}
\details{
The function (1) puts the data \code{df}
in SOLAR format, (2) separates it into
two parts, pedigree and phenotypes,
and then (3) expots both data sets in
the directory \code{dir}.

Pedigree or ID variables are detected by \code{matchIdNames} function.
}

