% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{applyChanges}
\alias{applyChanges}
\title{Apply a series of sound changes to a series of words.}
\usage{
applyChanges(data, changes, source, target, meta, highlight)
}
\arguments{
\item{data}{[soundcorrs] A \code{\link{soundcorrs}} object.}

\item{changes}{[soundchange] The list of \code{\link{soundchange}}'s to apply.}

\item{source}{[character] Name of the column containing words to which to apply \code{\link{soundchange}}'s.}

\item{target}{[character] Name of the column containing words to which to compare the results. Defaults to \code{NULL}.}

\item{meta}{[character] Name of the column containing metadata to be passed to \code{\link{soundchange}} functions alongside words. Defaults to \code{NULL}.}

\item{highlight}{[character] Highlight the differences between the intermediate forms in \code{$tree}, as well as between the results in \code{$end} and \code{target}? Can be \code{NULL} (do not highlight), \code{"console"} (highlight for the console), or \code{"HTML"} (highlight for a web browser). Defaults to \code{NULL}.}
}
\value{
[list.applyChanges] A list with three fields: \code{$end}, a named list with the final results; \code{$match}, a named list with one of three values: \code{0} when none of the final results matches the \code{target}, \code{0.5} when at least one of the final results matches the \code{target}, or \code{1} when all the final results match the \code{target}; lastly \code{$tree}, a list tracing all the intermediate forms.
}
\description{
Apply a list of \code{\link{soundchange}}'s to a series of words, possibly with additional metadata, and possibly compare the results to a prediction.
}
\details{
Functions in \code{\link{soundchange}} objects are allowed to return more than one value, which makes manual application of a series of changes highly inconvenient and prone to errors. This function automates the process, while keeping track of all the intermediate forms. It returns the result in three formats: only the final shapes; their comparison to the shapes given under the \code{target} argument; and a tree with all the steps along the way. By default, only the final shapes are printed. All the three formats are accessible as elements of a named list: \code{$end}, \code{$match}, and \code{$tree}, respectively.

Note that the application of sound changes does not require the data to be segmented and aligned. If sound changes are the only goal of the project, these two time-consuming steps can be safely omitted.
}
\examples{
# prepare sample data
dataset <- loadSampleDataset ("data-capitals")
changes <- list (loadSampleDataset("change-dl2l"), loadSampleDataset("change-rhotacism"))
# apply the changes
applyChanges (dataset, changes, "ORTHOGRAPHY.German")
applyChanges (dataset, changes, "ORTHOGRAPHY.German")$tree
applyChanges (dataset, changes, "ORTHOGRAPHY.German", "ORTHOGRAPHY.Polish", highlight="console")
}
\seealso{
\code{\link{print.list.applyChanges}}, \code{\link{print.tree.applyChanges}}
}
