% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_loudness.R
\name{scaleSPL}
\alias{scaleSPL}
\title{Scale SPL}
\usage{
scaleSPL(x, SPL_measured = 70, Pref = 2e-05)
}
\arguments{
\item{x}{numeric vector ranging from -1 to +1}

\item{SPL_measured}{sound pressure level at which the sound is presented, dB}

\item{Pref}{reference pressure, Pa}
}
\description{
Internal soundgen function
}
\details{
Converts a sound from SPL on any scale to a desired level of dB SPL.
See Timoney et al. (2004) "Implementing loudness models in MATLAB"
}
\examples{
sound = runif(100) * getSmoothContour(c(0, 1, 0), len = 100)
# plot(sound, type = 'l')
sound_scaled = soundgen:::scaleSPL(sound)
# plot(sound_scaled, type = 'l')
}
\keyword{internal}
