% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtl.R
\name{getFormantDispersion}
\alias{getFormantDispersion}
\title{Get formant dispersion}
\usage{
getFormantDispersion(formants, method = c("meanDispersion",
  "regression")[2], speedSound = 35400)
}
\arguments{
\item{formants}{a character string like "aaui" referring to default presets
for speaker "M1"; a vector of formant frequencies; or a list of formant
times, frequencies, amplitudes, and bandwidths, with a single value of each
for static or multiple values of each for moving formants}

\item{method}{the method of estimating vocal tract length (see details)}

\item{speedSound}{speed of sound in warm air, cm/s. Stevens (2000) "Acoustic
phonetics", p. 138}
}
\description{
Internal soundgen function.
}
\details{
Estimates formant dispersion based on one or more formant frequencies.
}
\examples{
soundgen:::getFormantDispersion(c(500, 1400, 2900, 3500),
  method = 'meanDispersion')
soundgen:::getFormantDispersion(c(500, 1400, 2900, 3500),
  method = 'regression')
soundgen:::getFormantDispersion(c(500, 1400, NA, 3500))
\dontrun{
nIter = 100  # nIter = 10000 for better results
speedSound = 35400
out = data.frame(vtl = runif(nIter, 5, 70),
                 nFormants = round(runif(nIter, 1, 10)),
                 noise = runif(nIter, 0, .2),
                 vtl_est = rep(NA, nIter),
                 error = rep(NA, nIter))
for (i in 1:nIter) {
  a = 1:out$nFormants[i]
  formants = sort(speedSound * (2 * a - 1) / (4 * out$vtl[i]) * rnorm(n = length(a),
                                                                 mean = 1,
                                                                 sd = out$noise[i]))
  disp = soundgen:::getFormantDispersion(formants, method = 'fast')
  out$vtl_est[i] = speedSound / 2 / disp
  out$error[i] = (out$vtl[i] -  out$vtl_est[i]) / out$vtl[i]
}

library(ggplot2)
ggplot(out, aes(x = nFormants, y = error)) +
  geom_point(alpha = .1) +
  geom_smooth() +
  theme_bw()
ggplot(out, aes(x = noise, y = error)) +
  geom_point(alpha = .1) +
  geom_smooth() +
  theme_bw()
}
}
\keyword{internal}
