% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{osc_dB}
\alias{osc_dB}
\title{Oscillogram on a decibell scale}
\usage{
osc_dB(
  x,
  dynamicRange = 80,
  dB = TRUE,
  maxAmpl = NULL,
  samplingRate = NULL,
  returnWave = FALSE,
  plot = TRUE,
  xlab = NULL,
  ylab = NULL,
  bty = "n",
  midline = TRUE,
  maxPoints = NULL,
  ...
)
}
\arguments{
\item{x}{path to a .wav file or a vector of amplitudes with specified
samplingRate}

\item{dynamicRange}{dynamic range of the oscillogram, dB}

\item{dB}{if TRUE, plots on a dB instead of linear scale}

\item{maxAmpl}{the maximum theoretically possible value indicating on which
scale the sound is coded: 1 if the range is -1 to +1, 2^15 for 16-bit wav
files, etc}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than a .wav file)}

\item{returnWave}{if TRUE, returns a log-transformed waveform as a numeric vector}

\item{plot}{if TRUE, plots the oscillogram}

\item{xlab}{axis labels}

\item{ylab}{axis labels}

\item{bty}{box type (see `?par`)}

\item{midline}{if TRUE, draws a line at 0 dB}

\item{maxPoints}{the maximum number of points to plot (speeds up the plotting
of long audio files, but beware of antialiasing)}

\item{...}{Other graphical parameters passed on to `plot()`}
}
\description{
Deprecated; use \code{link{osc}} instead.
}
\examples{
sound = sin(1:2000/10) *
        getSmoothContour(anchors = c(1, .01, .5), len = 2000)
osc_dB(sound)
}
