% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loudness.R
\name{.getLoudness}
\alias{.getLoudness}
\title{Loudness per sound}
\usage{
.getLoudness(
  audio,
  windowLength = 50,
  step = NULL,
  overlap = 50,
  SPL_measured = 70,
  Pref = 2e-05,
  spreadSpectrum = TRUE,
  plot = TRUE,
  savePlots = NULL,
  main = NULL,
  ylim = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  mar = c(5.1, 4.1, 4.1, 4.1),
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{SPL_measured}{sound pressure level at which the sound is presented, dB}

\item{Pref}{reference pressure, Pa (currently has no effect on the estimate)}

\item{spreadSpectrum}{if TRUE, applies a spreading function to account for
frequency masking}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{main}{graphical parameters for plotting}

\item{ylim}{frequency range to plot, kHz (defaults to 0 to Nyquist
frequency). NB: still in kHz, even if yScale = bark, mel, or ERB}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{mar}{margins of the spectrogram}

\item{...}{other plotting parameters passed to \code{\link{spectrogram}}}
}
\description{
Internal soundgen function
}
\keyword{internal}
