% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{simplex}
\alias{simplex}
\alias{simplex,sf-method}
\alias{simplex,SpatRaster-method}
\title{simplex forecasting}
\usage{
\S4method{simplex}{sf}(
  data,
  target,
  lib,
  pred = lib,
  E = 1:10,
  tau = 1,
  k = 4,
  nb = NULL,
  threads = detectThreads()
)

\S4method{simplex}{SpatRaster}(
  data,
  target,
  lib,
  pred = lib,
  E = 1:10,
  tau = 1,
  k = 4,
  threads = detectThreads()
)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{lib}{Row numbers(\code{vector}) of lattice data or row-column numbers(\code{matrix}) of grid data for creating the library from observations.}

\item{pred}{(optional) Row numbers(\code{vector}) of lattice data or row-column numbers(\code{matrix}) of grid data used for predictions.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors to use for prediction.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}
}
\value{
A matrix
}
\description{
simplex forecasting
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData"))
\donttest{
simplex(columbus,target = "CRIME",lib = 1:49)
}
}
