% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_functions.R
\name{split_graph_components}
\alias{split_graph_components}
\title{Split graph components}
\usage{
split_graph_components(graph_result)
}
\arguments{
\item{graph_result}{A list typically obtained from the function build_graph or build_graph_directed}
}
\value{
A list of lists, the graph_result split for each graph component
}
\description{
Function to split the results of build_graph and build_graph_directed
into their sub components
}
\examples{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- rgdal::readOGR(networkgpkg,layer="mtl_network", verbose=FALSE)
mtl_network$length <- rgeos::gLength(mtl_network, byid = TRUE)
graph_result <- build_graph(mtl_network, 2, "length", attrs = TRUE)
sub_elements <- split_graph_components(graph_result)
}
