% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection_cv_tnkde_sf.R
\name{bw_tnkde_corr_factor}
\alias{bw_tnkde_corr_factor}
\title{Time and Network bandwidth correction calculation}
\usage{
bw_tnkde_corr_factor(
  net_bws,
  time_bws,
  diggle_correction,
  study_area,
  events,
  events_loc,
  lines,
  method,
  kernel_name,
  tol,
  digits,
  max_depth,
  sparse
)
}
\arguments{
\item{net_bws}{A vector of network bandwidths}

\item{time_bws}{A vector of time bandwidths}

\item{diggle_correction}{A Boolean indicating if the correction factor
for edge effect must be used.}

\item{study_area}{A feature collection of polygons 
representing the limits of the study area.}

\item{events}{A feature collection of points representing the events}

\item{events_loc}{A feature collection of points representing the unique location of events}

\item{lines}{A feature collection of linestrings representing the underlying lines of the network}

\item{method}{The name of the NKDE to use}

\item{kernel_name}{The name of the kernel to use}

\item{tol}{float indicating the minimum distance between the events and the
lines' extremities when adding the point to the network. When points are
closer, they are added at the extremity of the lines.}

\item{digits}{An integer, the number of digits to keep for the spatial coordinates}

\item{max_depth}{The maximal depth for continuous or discontinuous NKDE}

\item{sparse}{A Boolean indicating if sparse or regular matrices should be
used by the Rcpp functions. These matrices are used to store edge indices
between two nodes in a graph. Regular matrices are faster, but require more
memory, in particular with multiprocessing. Sparse matrices are slower (a
bit), but require much less memory.}

\item{samples}{A feature collection of points representing the sample location}
}
\description{
Caclulating the border correction factor for both time and network bandwidths
}
\examples{
# no example provided, this is an internal function
}
\keyword{internal}
