/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import sparklyr.JVMObjectTracker$;

public final class Serializer$ {
    public static final Serializer$ MODULE$;
    private Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe;

    static {
        new Serializer$();
    }

    public Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe() {
        return this.sqlSerDe;
    }

    public void sqlSerDe_$eq(Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> x$1) {
        this.sqlSerDe = x$1;
    }

    public void registerSqlSerDe(Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe) {
        this.sqlSerDe_$eq(sqlSerDe);
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType);
    }

    public Object readTypedObject(DataInputStream dis, char dataType) {
        Object object;
        switch (dataType) {
            default: {
                if (this.sqlSerDe() == null || this.sqlSerDe()._1() == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)dataType)})));
                }
                Object obj = ((Function2)this.sqlSerDe()._1()).apply((Object)dis, (Object)BoxesRunTime.boxToCharacter((char)dataType));
                if (obj == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)dataType)})));
                }
                object = obj;
                break;
            }
            case 'j': {
                object = JVMObjectTracker$.MODULE$.getObject(this.readString(dis));
                break;
            }
            case 't': {
                object = this.readTime(dis);
                break;
            }
            case 'D': {
                object = this.readDate(dis);
                break;
            }
            case 'l': {
                object = this.readList(dis);
                break;
            }
            case 'a': {
                object = this.readArray(dis);
                break;
            }
            case 'r': {
                object = this.readBytes(dis);
                break;
            }
            case 'e': {
                object = this.readMap(dis);
                break;
            }
            case 'c': {
                object = this.readString(dis);
                break;
            }
            case 'b': {
                object = new Boolean(this.readBoolean(dis));
                break;
            }
            case 'd': {
                object = new Double(this.readDouble(dis));
                break;
            }
            case 'i': {
                object = new Integer(this.readInt(dis));
                break;
            }
            case 'n': {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        if (bytes[len - 1] != 0) {
            throw new IllegalArgumentException("length and stream do not match");
        }
        String str = new String((byte[])Predef$.MODULE$.byteArrayOps(bytes).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        int intVal = in.readInt();
        return intVal != 0;
    }

    public Date readDate(DataInputStream in) {
        return Date.valueOf(this.readString(in));
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$1;

            public final byte[] apply(int x$1) {
                return Serializer$.MODULE$.readBytes(this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            public final DataInputStream in$2;

            public final int apply(int x$2) {
                return Serializer$.MODULE$.readInt(this.in$2);
            }

            public int apply$mcII$sp(int x$2) {
                return Serializer$.MODULE$.readInt(this.in$2);
            }
            {
                this.in$2 = in$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            public final DataInputStream in$3;

            public final double apply(int x$3) {
                return Serializer$.MODULE$.readDouble(this.in$3);
            }

            public double apply$mcDI$sp(int x$3) {
                return Serializer$.MODULE$.readDouble(this.in$3);
            }
            {
                this.in$3 = in$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            public final DataInputStream in$4;

            public final boolean apply(int x$4) {
                return Serializer$.MODULE$.readBoolean(this.in$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return Serializer$.MODULE$.readBoolean(this.in$4);
            }
            {
                this.in$4 = in$4;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$5;

            public final String apply(int x$5) {
                return Serializer$.MODULE$.readString(this.in$5);
            }
            {
                this.in$5 = in$5;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readArrayArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$6;

            public final Object apply(int x$6) {
                return Serializer$.MODULE$.readArray(this.in$6);
            }
            {
                this.in$6 = in$6;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
    }

    public Object readListArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$7;

            public final Object[] apply(int x$7) {
                return Serializer$.MODULE$.readList(this.in$7);
            }
            {
                this.in$7 = in$7;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
    }

    public Date[] readDateArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (Date[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$8;

            public final Date apply(int x$8) {
                return Serializer$.MODULE$.readDate(this.in$8);
            }
            {
                this.in$8 = in$8;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Timestamp[] readTimeArr(DataInputStream in) {
        int len = this.readInt(in);
        Predef$ predef$ = Predef$.MODULE$;
        return (Timestamp[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final DataInputStream in$9;

            public final Timestamp apply(int x$9) {
                return Serializer$.MODULE$.readTime(this.in$9);
            }
            {
                this.in$9 = in$9;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public Object readArray(DataInputStream dis) {
        Object object;
        char arrType = this.readObjectType(dis);
        switch (arrType) {
            default: {
                if (this.sqlSerDe() == null || this.sqlSerDe()._1() == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid array type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)arrType)})));
                }
                int len = this.readInt(dis);
                Predef$ predef$ = Predef$.MODULE$;
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(dis, arrType){
                    public static final long serialVersionUID = 0L;
                    private final DataInputStream dis$1;
                    private final char arrType$1;

                    public final Object apply(int x$10) {
                        Object obj = ((Function2)Serializer$.MODULE$.sqlSerDe()._1()).apply((Object)this.dis$1, (Object)BoxesRunTime.boxToCharacter((char)this.arrType$1));
                        if (obj == null) {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid array type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)this.arrType$1)})));
                        }
                        return obj;
                    }
                    {
                        this.dis$1 = dis$1;
                        this.arrType$1 = arrType$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
                break;
            }
            case 't': {
                object = this.readTimeArr(dis);
                break;
            }
            case 'D': {
                object = this.readDateArr(dis);
                break;
            }
            case 'l': {
                object = this.readListArr(dis);
                break;
            }
            case 'a': {
                object = this.readArrayArr(dis);
                break;
            }
            case 'r': {
                object = this.readBytesArr(dis);
                break;
            }
            case 'j': {
                object = Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis)).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(String x) {
                        return JVMObjectTracker$.MODULE$.getObject(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
                break;
            }
            case 'b': {
                object = this.readBooleanArr(dis);
                break;
            }
            case 'd': {
                object = this.readDoubleArr(dis);
                break;
            }
            case 'c': {
                object = this.readStringArr(dis);
                break;
            }
            case 'i': {
                object = this.readIntArr(dis);
            }
        }
        return object;
    }

    public Object[] readList(DataInputStream dis) {
        int len = this.readInt(dis);
        Predef$ predef$ = Predef$.MODULE$;
        return (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(0, len).map((Function1)new Serializable(dis){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dis$2;

            public final Object apply(int x$11) {
                return Serializer$.MODULE$.readObject(this.dis$2);
            }
            {
                this.dis$2 = dis$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    public java.util.Map<Object, Object> readMap(DataInputStream in) {
        java.util.Map<Object, Object> map;
        int len = this.readInt(in);
        if (len > 0) {
            Object[] keys = (Object[])this.readArray(in);
            Object[] values = this.readList(in);
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(keys).zip((GenIterable)Predef$.MODULE$.wrapRefArray(values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms())).asJava();
        } else {
            map = new HashMap<Object, Object>();
        }
        return map;
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        block14: {
            block3: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            if ("void" != null ? !"void".equals(typeStr) : typeStr != null) break block2;
                                                            dos.writeByte(110);
                                                            break block3;
                                                        }
                                                        if ("character" != null ? !"character".equals(typeStr) : typeStr != null) break block4;
                                                        dos.writeByte(99);
                                                        break block3;
                                                    }
                                                    if ("double" != null ? !"double".equals(typeStr) : typeStr != null) break block5;
                                                    dos.writeByte(100);
                                                    break block3;
                                                }
                                                if ("integer" != null ? !"integer".equals(typeStr) : typeStr != null) break block6;
                                                dos.writeByte(105);
                                                break block3;
                                            }
                                            if ("logical" != null ? !"logical".equals(typeStr) : typeStr != null) break block7;
                                            dos.writeByte(98);
                                            break block3;
                                        }
                                        if ("date" != null ? !"date".equals(typeStr) : typeStr != null) break block8;
                                        dos.writeByte(68);
                                        break block3;
                                    }
                                    if ("time" != null ? !"time".equals(typeStr) : typeStr != null) break block9;
                                    dos.writeByte(116);
                                    break block3;
                                }
                                if ("raw" != null ? !"raw".equals(typeStr) : typeStr != null) break block10;
                                dos.writeByte(114);
                                break block3;
                            }
                            if ("array" != null ? !"array".equals(typeStr) : typeStr != null) break block11;
                            dos.writeByte(97);
                            break block3;
                        }
                        if ("list" != null ? !"list".equals(typeStr) : typeStr != null) break block12;
                        dos.writeByte(108);
                        break block3;
                    }
                    if ("map" != null ? !"map".equals(typeStr) : typeStr != null) break block13;
                    dos.writeByte(101);
                    break block3;
                }
                if ("jobj" != null ? !"jobj".equals(typeStr) : typeStr != null) break block14;
                dos.writeByte(106);
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeStr})));
    }

    public void sparklyr$Serializer$$writeKeyValue(DataOutputStream dos, Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key in map can't be null.");
        }
        if (key instanceof String) {
            this.writeString(dos, (String)key);
            this.writeObject(dos, value);
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid map key type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.getClass().getName()})));
    }

    public void writeObject(DataOutputStream dos, Object obj) {
        if (obj == null) {
            this.writeType(dos, "void");
        } else {
            Object value;
            Object object = value = obj instanceof WrappedArray ? ((WrappedArray)obj).toArray(ClassTag$.MODULE$.apply(Object.class)) : obj;
            if (value instanceof Character) {
                Character c = (Character)value;
                this.writeType(dos, "character");
                this.writeString(dos, c.toString());
            } else if (value instanceof String) {
                String string = (String)value;
                this.writeType(dos, "character");
                this.writeString(dos, string);
            } else if (value instanceof Long) {
                Long l = (Long)value;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Long2long(l));
            } else if (value instanceof Float) {
                Float f2 = (Float)value;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Float2float(f2));
            } else if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value;
                this.writeType(dos, "double");
                this.writeDouble(dos, BigDecimal$.MODULE$.apply(bigDecimal).toDouble());
            } else if (value instanceof Double) {
                Double d = (Double)value;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Double2double(d));
            } else if (value instanceof Byte) {
                Byte by = (Byte)value;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Byte2byte(by));
            } else if (value instanceof Short) {
                Short s = (Short)value;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Short2short(s));
            } else if (value instanceof Integer) {
                Integer n = (Integer)value;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Integer2int(n));
            } else if (value instanceof Boolean) {
                Boolean bl = (Boolean)value;
                this.writeType(dos, "logical");
                this.writeBoolean(dos, Predef$.MODULE$.Boolean2boolean(bl));
            } else if (value instanceof Date) {
                Date date = (Date)value;
                this.writeType(dos, "date");
                this.writeDate(dos, date);
            } else if (value instanceof Time) {
                Time time = (Time)value;
                this.writeType(dos, "time");
                this.writeTime(dos, time);
            } else if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                this.writeType(dos, "time");
                this.writeTime(dos, timestamp);
            } else if (value instanceof GenericRowWithSchema) {
                GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)value;
                this.writeType(dos, "list");
                this.writeInt(dos, genericRowWithSchema.length());
                genericRowWithSchema.toSeq().foreach((Function1)new Serializable(dos){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputStream dos$1;

                    public final void apply(Object elem) {
                        Serializer$.MODULE$.writeObject(this.dos$1, elem);
                    }
                    {
                        this.dos$1 = dos$1;
                    }
                });
            } else if (value instanceof byte[]) {
                byte[] byArray = (byte[])value;
                this.writeType(dos, "raw");
                this.writeBytes(dos, byArray);
            } else if (value instanceof char[]) {
                char[] cArray = (char[])value;
                this.writeType(dos, "array");
                this.writeStringArr(dos, (String[])Predef$.MODULE$.charArrayOps(cArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char x$12) {
                        return ((Object)BoxesRunTime.boxToCharacter((char)x$12)).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            } else if (value instanceof short[]) {
                short[] sArray = (short[])value;
                this.writeType(dos, "array");
                this.writeIntArr(dos, (int[])Predef$.MODULE$.shortArrayOps(sArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(short x$13) {
                        return x$13;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            } else if (value instanceof int[]) {
                int[] nArray = (int[])value;
                this.writeType(dos, "array");
                this.writeIntArr(dos, nArray);
            } else if (value instanceof long[]) {
                long[] lArray = (long[])value;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])Predef$.MODULE$.longArrayOps(lArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(long x$14) {
                        return x$14;
                    }

                    public double apply$mcDJ$sp(long x$14) {
                        return x$14;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            } else if (value instanceof float[]) {
                float[] fArray = (float[])value;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])Predef$.MODULE$.floatArrayOps(fArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$15) {
                        return x$15;
                    }

                    public double apply$mcDF$sp(float x$15) {
                        return x$15;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            } else if (value instanceof double[]) {
                double[] dArray = (double[])value;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, dArray);
            } else if (value instanceof boolean[]) {
                boolean[] blArray = (boolean[])value;
                this.writeType(dos, "array");
                this.writeBooleanArr(dos, blArray);
            } else if (value instanceof Timestamp[]) {
                Timestamp[] timestampArray = (Timestamp[])value;
                this.writeType(dos, "array");
                this.writeTimestampArr(dos, timestampArray);
            } else if (value instanceof Date[]) {
                Date[] dateArray = (Date[])value;
                this.writeType(dos, "array");
                this.writeDateArr(dos, dateArray);
            } else if (value instanceof Object[]) {
                Object[] objectArray = (Object[])value;
                this.writeType(dos, "list");
                this.writeInt(dos, objectArray.length);
                Predef$.MODULE$.refArrayOps(objectArray).foreach((Function1)new Serializable(dos){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputStream dos$1;

                    public final void apply(Object elem) {
                        Serializer$.MODULE$.writeObject(this.dos$1, elem);
                    }
                    {
                        this.dos$1 = dos$1;
                    }
                });
            } else if (value instanceof Tuple3) {
                Tuple3 tuple3 = (Tuple3)value;
                this.writeType(dos, "list");
                this.writeInt(dos, tuple3.productArity());
                tuple3.productIterator().foreach((Function1)new Serializable(dos){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputStream dos$1;

                    public final void apply(Object elem) {
                        Serializer$.MODULE$.writeObject(this.dos$1, elem);
                    }
                    {
                        this.dos$1 = dos$1;
                    }
                });
            } else if (value instanceof Properties) {
                this.writeType(dos, "jobj");
                this.writeJObj(dos, value);
            } else if (value instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)value;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value2 = entry.getValue();
                    this.sparklyr$Serializer$$writeKeyValue(dos, key, value2);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                map.foreach((Function1)new Serializable(dos){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputStream dos$1;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        if (x0$1 != null) {
                            Serializer$.MODULE$.sparklyr$Serializer$$writeKeyValue(this.dos$1, x0$1._1(), x0$1._2());
                            return;
                        }
                        throw new MatchError(x0$1);
                    }
                    {
                        this.dos$1 = dos$1;
                    }
                });
            } else if (this.sqlSerDe() == null || this.sqlSerDe()._2() == null || !BoxesRunTime.unboxToBoolean((Object)((Function2)this.sqlSerDe()._2()).apply((Object)dos, value))) {
                this.writeType(dos, "jobj");
                this.writeJObj(dos, value);
            }
        }
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        int intValue = value ? 1 : 0;
        out.writeInt(intValue);
    }

    public void writeDate(DataOutputStream out, Date value) {
        this.writeString(out, value.toString());
    }

    public void writeTime(DataOutputStream out, Time value) {
        out.writeDouble((double)value.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value) {
        out.writeDouble((double)(value.getTime() / 1000L) + (double)value.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeJObj(DataOutputStream out, Object value) {
        String objId = JVMObjectTracker$.MODULE$.put(value);
        this.writeString(out, objId);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        Predef$.MODULE$.intArrayOps(value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            public final DataOutputStream out$2;

            public final void apply(int v) {
                this.out$2.writeInt(v);
            }

            public void apply$mcVI$sp(int v) {
                this.out$2.writeInt(v);
            }
            {
                this.out$2 = out$2;
            }
        });
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        Predef$.MODULE$.doubleArrayOps(value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            public final DataOutputStream out$3;

            public final void apply(double v) {
                this.out$3.writeDouble(v);
            }

            public void apply$mcVD$sp(double v) {
                this.out$3.writeDouble(v);
            }
            {
                this.out$3 = out$3;
            }
        });
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        Predef$.MODULE$.booleanArrayOps(value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$4;

            public final void apply(boolean v) {
                Serializer$.MODULE$.writeBoolean(this.out$4, v);
            }
            {
                this.out$4 = out$4;
            }
        });
    }

    public void writeTimestampArr(DataOutputStream out, Timestamp[] value) {
        this.writeType(out, "time");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$5;

            public final void apply(Timestamp v) {
                Serializer$.MODULE$.writeTime(this.out$5, v);
            }
            {
                this.out$5 = out$5;
            }
        });
    }

    public void writeDateArr(DataOutputStream out, Date[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$6;

            public final void apply(Date v) {
                Serializer$.MODULE$.writeTime(this.out$6, new Timestamp(v.getTime()));
            }
            {
                this.out$6 = out$6;
            }
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        this.writeType(out, "character");
        out.writeInt(value.length);
        Predef$.MODULE$.refArrayOps((Object[])value).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream out$1;

            public final void apply(String v) {
                Serializer$.MODULE$.writeString(this.out$1, v);
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

