/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import sparklyr.Logger;
import sparklyr.Serializer$;

public final class RUtils$ {
    public static final RUtils$ MODULE$;
    private final char XDR_FORMAT;
    public final int sparklyr$RUtils$$CHARSXP;
    public final int sparklyr$RUtils$$LGLSXP;
    public final int sparklyr$RUtils$$INTSXP;
    public final int sparklyr$RUtils$$REALSXP;
    public final int sparklyr$RUtils$$STRSXP;
    private final int VECSXP;
    public final int sparklyr$RUtils$$RAWSXP;
    public final int sparklyr$RUtils$$NILVALUE_SXP;
    public final int sparklyr$RUtils$$NA_INTEGER;

    static {
        new RUtils$();
    }

    public void validateSerializationFormat(DataInputStream dis, boolean verbose) {
        char format = Serializer$.MODULE$.readObjectType(dis);
        dis.readByte();
        if (this.XDR_FORMAT != format) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported R serialization format '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)format)})));
        }
        int version = Serializer$.MODULE$.readInt(dis);
        int writerVersion = Serializer$.MODULE$.readInt(dis);
        int minReaderVersion = Serializer$.MODULE$.readInt(dis);
        if (version != 2) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported R serialization version '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
        }
        if (verbose) {
            Logger logger = new Logger("Utils", 0);
            logger.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
            logger.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R serialization writer version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)writerVersion)})));
            logger.log(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"R serialization min reader version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)minReaderVersion)})));
        }
    }

    public boolean validateSerializationFormat$default$2() {
        return false;
    }

    public Object[] unserializeColumn(DataInputStream dis) {
        Logger logger = new Logger("RUtils", 0);
        int dtype = this.sparklyr$RUtils$$readDataType(dis);
        if (this.VECSXP != dtype) {
            logger.logWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected column data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dtype)})));
        }
        long num_rows = this.sparklyr$RUtils$$readLength(dis);
        Predef$ predef$ = Predef$.MODULE$;
        return (Object[])((TraversableOnce)new RichLong(0L).until((Object)BoxesRunTime.boxToLong((long)num_rows)).map((Function1)new Serializable(dis, logger){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dis$1;
            private final Logger logger$1;

            /*
             * WARNING - void declaration
             */
            public final Object apply(long r) {
                int elem_dtype;
                block14: {
                    Boolean bl;
                    block8: {
                        Comparable<Boolean> comparable;
                        block11: {
                            String string;
                            int strlen;
                            block13: {
                                block12: {
                                    block10: {
                                        long num_elems;
                                        block9: {
                                            void var3_4;
                                            block7: {
                                                elem_dtype = RUtils$.MODULE$.sparklyr$RUtils$$readDataType(this.dis$1);
                                                if (RUtils$.MODULE$.sparklyr$RUtils$$NILVALUE_SXP != elem_dtype) break block7;
                                                bl = null;
                                                break block8;
                                            }
                                            num_elems = RUtils$.MODULE$.sparklyr$RUtils$$readLength(this.dis$1);
                                            if (RUtils$.MODULE$.sparklyr$RUtils$$RAWSXP != elem_dtype) break block9;
                                            byte[] bytes = new byte[Predef$.MODULE$.long2Long(num_elems).intValue()];
                                            this.dis$1.readFully(bytes);
                                            bl = var3_4;
                                            break block8;
                                        }
                                        if (1L != num_elems) {
                                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected number of elements: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)num_elems)})));
                                        }
                                        if (RUtils$.MODULE$.sparklyr$RUtils$$LGLSXP != elem_dtype) break block10;
                                        int v = Serializer$.MODULE$.readInt(this.dis$1);
                                        comparable = RUtils$.MODULE$.sparklyr$RUtils$$NA_INTEGER == v ? null : BoxesRunTime.boxToBoolean((v != 0 ? 1 : 0) != 0);
                                        break block11;
                                    }
                                    if (RUtils$.MODULE$.sparklyr$RUtils$$INTSXP != elem_dtype) break block12;
                                    int v = Serializer$.MODULE$.readInt(this.dis$1);
                                    comparable = RUtils$.MODULE$.sparklyr$RUtils$$NA_INTEGER == v ? null : BoxesRunTime.boxToInteger((int)v);
                                    break block11;
                                }
                                if (RUtils$.MODULE$.sparklyr$RUtils$$REALSXP != elem_dtype) break block13;
                                byte[] bytes = new byte[8];
                                this.dis$1.readFully(bytes);
                                long hw = (long)RUtils$.MODULE$.sparklyr$RUtils$$extractInt(bytes, 0) & 0xFFFFFFFFL;
                                long lw = (long)RUtils$.MODULE$.sparklyr$RUtils$$extractInt(bytes, 4) & 0xFFFFFFFFL;
                                comparable = hw == 0x7FF00000L && lw == 1954L ? null : BoxesRunTime.boxToDouble((double)Double.longBitsToDouble(hw << 32 | lw));
                                break block11;
                            }
                            if (RUtils$.MODULE$.sparklyr$RUtils$$STRSXP != elem_dtype) break block14;
                            int ctype = RUtils$.MODULE$.sparklyr$RUtils$$readDataType(this.dis$1);
                            if (RUtils$.MODULE$.sparklyr$RUtils$$CHARSXP != ctype) {
                                this.logger$1.logWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected character type ", " found in string expression"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctype)})));
                            }
                            if (-1L == (long)(strlen = Serializer$.MODULE$.readInt(this.dis$1))) {
                                string = null;
                            } else {
                                byte[] bytes = new byte[Predef$.MODULE$.int2Integer(strlen).intValue()];
                                this.dis$1.readFully(bytes);
                                string = new String(bytes, StandardCharsets.UTF_8);
                            }
                            comparable = string;
                        }
                        bl = comparable;
                    }
                    return bl;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)elem_dtype)})));
            }
            {
                this.dis$1 = dis$1;
                this.logger$1 = logger$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
    }

    private int[] unserializeIntColumn(DataInputStream dis) {
        return (int[])Array$.MODULE$.fill(5, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return 0;
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Int());
    }

    private String[] unserializeStringColumn(DataInputStream dis) {
        return (String[])Array$.MODULE$.fill(5, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public int sparklyr$RUtils$$readDataType(DataInputStream dis) {
        return Serializer$.MODULE$.readInt(dis) & 0xFF;
    }

    public long sparklyr$RUtils$$readLength(DataInputStream dis) {
        int x = Serializer$.MODULE$.readInt(dis);
        if (-1 == x) {
            throw new IllegalArgumentException("Vector with length greater than INT_MAX (i.e., 'LONG_VECTOR') is not supported yet");
        }
        if (x < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Negative serialized vector length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})));
        }
        return x;
    }

    public int sparklyr$RUtils$$extractInt(byte[] bytes, int offset) {
        Predef$ predef$ = Predef$.MODULE$;
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(0, 4).map((Function1)new Serializable(bytes, offset){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;
            private final int offset$1;

            public final int apply(int i) {
                return this.apply$mcII$sp(i);
            }

            public int apply$mcII$sp(int i) {
                return (Predef$.MODULE$.byte2Byte(this.bytes$1[this.offset$1 + i]).intValue() & 0xFF) << 24 - i * 8;
            }
            {
                this.bytes$1 = bytes$1;
                this.offset$1 = offset$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int p, int q) {
                return p | q;
            }

            public int apply$mcIII$sp(int p, int q) {
                return p | q;
            }
        }));
    }

    private RUtils$() {
        MODULE$ = this;
        this.XDR_FORMAT = (char)88;
        this.sparklyr$RUtils$$CHARSXP = 9;
        this.sparklyr$RUtils$$LGLSXP = 10;
        this.sparklyr$RUtils$$INTSXP = 13;
        this.sparklyr$RUtils$$REALSXP = 14;
        this.sparklyr$RUtils$$STRSXP = 16;
        this.VECSXP = 19;
        this.sparklyr$RUtils$$RAWSXP = 24;
        this.sparklyr$RUtils$$NILVALUE_SXP = 254;
        this.sparklyr$RUtils$$NA_INTEGER = Integer.MIN_VALUE;
    }
}

