/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import sparklyr.Backend;
import sparklyr.JVMObjectTracker;
import sparklyr.Logger;
import sparklyr.Rscript;
import sparklyr.Sources$;
import sparklyr.WorkerContext;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u000b\u0017\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AA\b\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\t\u0005A!A!\u0002\u0013\u0001\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011\r\u0003!\u0011!Q\u0001\nEB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005}!A\u0011\n\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003F\u0011!Y\u0005A!A!\u0002\u0013\t\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011m\u0003!\u0011!Q\u0001\nqC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0006K\u0002!\tA\u001a\u0005\u0007q\u0002\u0001\u000b\u0015B=\t\u000f\u0005-\u0001\u0001)Q\u0005}!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0002\f/>\u00148.\u001a:BaBd\u0017PC\u0001\u0018\u0003!\u0019\b/\u0019:lYf\u00148\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004dY>\u001cXO]3\u0011\u0007mQC&\u0003\u0002,9\t)\u0011I\u001d:bsB\u00111$L\u0005\u0003]q\u0011AAQ=uK\u000691m\u001c7v[:\u001c\bcA\u000e+cA\u0011!'\u000f\b\u0003g]\u0002\"\u0001\u000e\u000f\u000e\u0003UR!A\u000e\r\u0002\rq\u0012xn\u001c;?\u0013\tAD$\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u001d\u0003\u0019\u0019wN\u001c4jO\u0006!\u0001o\u001c:u!\tYr(\u0003\u0002A9\t\u0019\u0011J\u001c;\u0002\u000f\u001d\u0014x.\u001e9Cs\u0006a1\r\\8tkJ,'\u000bT1oO\u0006Q!-\u001e8eY\u0016\u0004\u0016\r\u001e5\u0002\u0013\r,8\u000f^8n\u000b:4\b\u0003\u0002\u001aGcEJ!aR\u001e\u0003\u00075\u000b\u0007/A\td_:tWm\u0019;j_:$\u0016.\\3pkR\fqaY8oi\u0016DH/A\u0004paRLwN\\:\u0002\u0015QLW.\u001a.p]\u0016LE-\u0001\u0004tG\",W.\u0019\t\u0003\u001dfk\u0011a\u0014\u0006\u0003!F\u000bQ\u0001^=qKNT!AU*\u0002\u0007M\fHN\u0003\u0002U+\u0006)1\u000f]1sW*\u0011akV\u0001\u0007CB\f7\r[3\u000b\u0003a\u000b1a\u001c:h\u0013\tQvJ\u0001\u0006TiJ,8\r\u001e+za\u0016\fQbZ3o\u0005\u0006\u0014(/[3s\u001b\u0006\u0004\bcA\u000e^?&\u0011a\f\b\u0002\n\rVt7\r^5p]B\u0002BA\r$2AB\u00111$Y\u0005\u0003Er\u00111!\u00118z\u0003E9WM\u001c)beRLG/[8o\u0013:$W\r\u001f\t\u00047us\u0014A\u0002\u001fj]&$h\b\u0006\thS*\\G.\u001c8paF\u00148\u000f^;woB\u0011\u0001\u000eA\u0007\u0002-!)\u0001\u0006\u0005a\u0001S!)q\u0006\u0005a\u0001a!)A\b\u0005a\u0001c!)Q\b\u0005a\u0001}!)\u0011\t\u0005a\u0001a!)!\t\u0005a\u0001S!)1\t\u0005a\u0001c!)A\t\u0005a\u0001\u000b\")\u0001\n\u0005a\u0001}!)\u0011\n\u0005a\u0001S!)!\n\u0005a\u0001\u000b\")1\n\u0005a\u0001c!)A\n\u0005a\u0001\u001b\")1\f\u0005a\u00019\")1\r\u0005a\u0001I\u0006IQ\r_2faRLwN\u001c\t\u00047id\u0018BA>\u001d\u0005\u0019y\u0005\u000f^5p]B\u0019Q0!\u0002\u000f\u0007y\f\tA\u0004\u00025\u007f&\tQ$C\u0002\u0002\u0004q\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!!C#yG\u0016\u0004H/[8o\u0015\r\t\u0019\u0001H\u0001\fE\u0006\u001c7.\u001a8e!>\u0014H/\u0001\tx_J\\WM]*pkJ\u001cWMR5mKR)\u0011'!\u0005\u0002\u001c!9\u00111C\nA\u0002\u0005U\u0011a\u0002:tGJL\u0007\u000f\u001e\t\u0004Q\u0006]\u0011bAA\r-\t9!k]2sSB$\bBBA\u000f'\u0001\u0007a(A\u0005tKN\u001c\u0018n\u001c8JI\u0006)\u0011\r\u001d9msR!\u00111EA\u0019!\u0015i\u0018QEA\u0015\u0013\u0011\t9#!\u0003\u0003\u0011%#XM]1u_J\u0004B!a\u000b\u0002.5\t\u0011+C\u0002\u00020E\u00131AU8x\u0011\u001d\t\u0019\u0004\u0006a\u0001\u0003G\t\u0001\"\u001b;fe\u0006$xN\u001d")
public class WorkerApply
implements Serializable {
    private final byte[] closure;
    private final String[] columns;
    public final String sparklyr$WorkerApply$$config;
    private final int port;
    private final String[] groupBy;
    private final byte[] closureRLang;
    private final String bundlePath;
    public final Map<String, String> sparklyr$WorkerApply$$customEnv;
    private final int connectionTimeout;
    private final byte[] context;
    public final Map<String, String> sparklyr$WorkerApply$$options;
    private final String timeZoneId;
    private final StructType schema;
    private final Function0<Map<String, Object>> genBarrierMap;
    private final Function0<Object> genPartitionIndex;
    public Option<Exception> sparklyr$WorkerApply$$exception;
    public int sparklyr$WorkerApply$$backendPort;

    public String workerSourceFile(Rscript rscript, int sessionId) {
        String source = Sources$.MODULE$.sources();
        File tempFile = new File(new StringBuilder(14).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)rscript.getScratchDir()), File.separator)).append("sparkworker_").append(((Object)BoxesRunTime.boxToInteger((int)sessionId)).toString()).append(".R").toString());
        FileWriter outStream = new FileWriter(tempFile);
        outStream.write(source);
        outStream.flush();
        return tempFile.getAbsolutePath();
    }

    public Iterator<Row> apply(Iterator<Row> iterator) {
        int sessionId = Random$.MODULE$.nextInt(10000);
        Logger logger = new Logger("Worker", sessionId);
        Object lock = new Object();
        if (!iterator.hasNext()) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Row.class)))).iterator();
        }
        WorkerContext workerContext = new WorkerContext(iterator, lock, this.closure, this.columns, this.groupBy, this.closureRLang, this.bundlePath, this.context, this.timeZoneId, this.schema, this.sparklyr$WorkerApply$$options, (Map<String, Object>)((Map)this.genBarrierMap.apply()), this.genPartitionIndex.apply$mcI$sp());
        JVMObjectTracker tracker = new JVMObjectTracker();
        String contextId = tracker.put(workerContext);
        logger.log(new StringBuilder(33).append("is tracking worker context under ").append(contextId).toString());
        logger.log("initializing backend");
        Backend backend = new Backend();
        backend.setTracker(tracker);
        backend.setType(true, false, true, false);
        backend.setHostContext(contextId);
        backend.init(this.port, sessionId, this.connectionTimeout);
        this.sparklyr$WorkerApply$$backendPort = backend.getPort();
        new Thread(this, logger, backend, lock){
            private final /* synthetic */ WorkerApply $outer;
            private final Logger logger$1;
            private final Backend backend$1;
            private final Object lock$1;

            public void run() {
                try {
                    this.logger$1.log("starting backend");
                    this.backend$1.run();
                }
                catch (Exception e) {
                    this.logger$1.logError("failed while running backend: ", e);
                    this.$outer.sparklyr$WorkerApply$$exception = new Some((Object)e);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logger$1 = logger$1;
                this.backend$1 = backend$1;
                this.lock$1 = lock$1;
                super("starting backend thread");
            }
        }.start();
        new Thread(this, logger, sessionId, lock){
            private final /* synthetic */ WorkerApply $outer;
            private final Logger logger$1;
            private final int sessionId$1;
            private final Object lock$1;

            public void run() {
                try {
                    this.logger$1.log("is starting rscript");
                    Rscript rscript = new Rscript(this.logger$1);
                    String sourceFilePath = this.$outer.workerSourceFile(rscript, this.sessionId$1);
                    rscript.init((List<String>)new .colon.colon((Object)((Object)BoxesRunTime.boxToInteger((int)this.sessionId$1)).toString(), (List)new .colon.colon((Object)((Object)BoxesRunTime.boxToInteger((int)this.$outer.sparklyr$WorkerApply$$backendPort)).toString(), (List)new .colon.colon((Object)this.$outer.sparklyr$WorkerApply$$config, (List)Nil$.MODULE$))), sourceFilePath, this.$outer.sparklyr$WorkerApply$$customEnv, this.$outer.sparklyr$WorkerApply$$options);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
                catch (Exception e) {
                    this.logger$1.logError("failed to run rscript: ", e);
                    this.$outer.sparklyr$WorkerApply$$exception = new Some((Object)e);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logger$1 = logger$1;
                this.sessionId$1 = sessionId$1;
                this.lock$1 = lock$1;
                super("starting rscript thread");
            }
        }.start();
        logger.log("is waiting using lock for RScript to complete");
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
        logger.log("completed wait using lock for RScript");
        if (this.sparklyr$WorkerApply$$exception.isDefined()) {
            throw (Throwable)this.sparklyr$WorkerApply$$exception.get();
        }
        logger.log(new StringBuilder(36).append("is returning RDD iterator with ").append(workerContext.getResultArray().length).append(" rows").toString());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])workerContext.getResultArray())).iterator();
    }

    public WorkerApply(byte[] closure, String[] columns, String config, int port, String[] groupBy, byte[] closureRLang, String bundlePath, Map<String, String> customEnv, int connectionTimeout, byte[] context, Map<String, String> options, String timeZoneId, StructType schema, Function0<Map<String, Object>> genBarrierMap, Function0<Object> genPartitionIndex) {
        this.closure = closure;
        this.columns = columns;
        this.sparklyr$WorkerApply$$config = config;
        this.port = port;
        this.groupBy = groupBy;
        this.closureRLang = closureRLang;
        this.bundlePath = bundlePath;
        this.sparklyr$WorkerApply$$customEnv = customEnv;
        this.connectionTimeout = connectionTimeout;
        this.context = context;
        this.sparklyr$WorkerApply$$options = options;
        this.timeZoneId = timeZoneId;
        this.schema = schema;
        this.genBarrierMap = genBarrierMap;
        this.genPartitionIndex = genPartitionIndex;
        this.sparklyr$WorkerApply$$exception = None$.MODULE$;
        this.sparklyr$WorkerApply$$backendPort = 0;
    }
}

