% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_word2vec.R
\name{ft_word2vec}
\alias{ft_word2vec}
\alias{ml_find_synonyms}
\title{Feature Transformation -- Word2Vec (Estimator)}
\usage{
ft_word2vec(
  x,
  input_col = NULL,
  output_col = NULL,
  vector_size = 100,
  min_count = 5,
  max_sentence_length = 1000,
  num_partitions = 1,
  step_size = 0.025,
  max_iter = 1,
  seed = NULL,
  uid = random_string("word2vec_"),
  ...
)

ml_find_synonyms(model, word, num)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{input_col}{The name of the input column.}

\item{output_col}{The name of the output column.}

\item{vector_size}{The dimension of the code that you want to transform from words. Default: 100}

\item{min_count}{The minimum number of times a token must appear to be included in
the word2vec model's vocabulary. Default: 5}

\item{max_sentence_length}{(Spark 2.0.0+) Sets the maximum length (in words) of each sentence
in the input data. Any sentence longer than this threshold will be divided into
chunks of up to \code{max_sentence_length} size. Default: 1000}

\item{num_partitions}{Number of partitions for sentences of words. Default: 1}

\item{step_size}{Param for Step size to be used for each iteration of optimization (> 0).}

\item{max_iter}{The maximum number of iterations to use.}

\item{seed}{A random seed. Set this value if you need your results to be
reproducible across repeated calls.}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}

\item{model}{A fitted \code{Word2Vec} model, returned by \code{ft_word2vec()}.}

\item{word}{A word, as a length-one character vector.}

\item{num}{Number of words closest in similarity to the given word to find.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} or a
\code{ml_estimator} object. If it is a \code{ml_pipeline}, it will return
a pipeline with the transformer or estimator appended to it. If a
\code{tbl_spark}, it will return a \code{tbl_spark} with the transformation
 applied to it.

\code{ml_find_synonyms()} returns a DataFrame of synonyms and cosine similarities
}
\description{
Word2Vec transforms a word into a code for further natural language processing or machine learning process.
}
\details{
In the case where \code{x} is a \code{tbl_spark}, the estimator
fits against \code{x} to obtain a transformer, returning a \code{tbl_spark}.
}
\seealso{
Other feature transformers: 
\code{\link{ft_binarizer}()},
\code{\link{ft_bucketizer}()},
\code{\link{ft_chisq_selector}()},
\code{\link{ft_count_vectorizer}()},
\code{\link{ft_dct}()},
\code{\link{ft_elementwise_product}()},
\code{\link{ft_feature_hasher}()},
\code{\link{ft_hashing_tf}()},
\code{\link{ft_idf}()},
\code{\link{ft_imputer}()},
\code{\link{ft_index_to_string}()},
\code{\link{ft_interaction}()},
\code{\link{ft_lsh}},
\code{\link{ft_max_abs_scaler}()},
\code{\link{ft_min_max_scaler}()},
\code{\link{ft_ngram}()},
\code{\link{ft_normalizer}()},
\code{\link{ft_one_hot_encoder_estimator}()},
\code{\link{ft_one_hot_encoder}()},
\code{\link{ft_pca}()},
\code{\link{ft_polynomial_expansion}()},
\code{\link{ft_quantile_discretizer}()},
\code{\link{ft_r_formula}()},
\code{\link{ft_regex_tokenizer}()},
\code{\link{ft_robust_scaler}()},
\code{\link{ft_sql_transformer}()},
\code{\link{ft_standard_scaler}()},
\code{\link{ft_stop_words_remover}()},
\code{\link{ft_string_indexer}()},
\code{\link{ft_tokenizer}()},
\code{\link{ft_vector_assembler}()},
\code{\link{ft_vector_indexer}()},
\code{\link{ft_vector_slicer}()}
}
\concept{feature transformers}
