\name{cov_pool}
\alias{cov_pool}
\title{Computes the pooled maximum likelihood estimator (MLE) for the common
covariance matrix}
\usage{
cov_pool(x, y)
}
\arguments{
  \item{x}{data matrix with \code{n} observations and
  \code{p} feature vectors}

  \item{y}{class labels for observations (rows) in
  \code{x}}
}
\value{
pooled sample covariance matrix of size \eqn{p \times p}
}
\description{
For the matrix \code{x}, we compute the MLE for the
population covariance matrix under the assumption that the
data are sampled from \eqn{K} multivariate normal
populations having equal covariance matrices.
}
\examples{
cov_pool(iris[, -5], iris$Species)
}

