% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_dummy.R
\name{sparse_dummy}
\alias{sparse_dummy}
\title{Generate sparse dummy variables}
\usage{
sparse_dummy(x, one_hot = TRUE)
}
\arguments{
\item{x}{A factor.}

\item{one_hot}{A single logical value. Should the first factor level be
included or not. Defaults to \code{FALSE}.}
}
\value{
A list of sparse integer dummy variables.
}
\description{
Generate sparse dummy variables
}
\details{
Only factor variables can be used with \code{\link[=sparse_dummy]{sparse_dummy()}}. A call to
\code{as.factor()} would be required for any other type of data.

If only a single level is present after \code{one_hot} takes effect. Then the
vector produced won't be sparse.

A missing value at the \code{i}th element will produce missing values for all
dummy variables at thr \code{i}th position.
}
\examples{
x <- factor(c("a", "a", "b", "c", "d", "b"))

sparse_dummy(x, one_hot = FALSE)

x <- factor(c("a", "a", "b", "c", "d", "b"))

sparse_dummy(x, one_hot = TRUE)

x <- factor(c("a", NA, "b", "c", "d", NA))

sparse_dummy(x, one_hot = FALSE)

x <- factor(c("a", NA, "b", "c", "d", NA))

sparse_dummy(x, one_hot = TRUE)
}
