aa_analyse_all_sample_sizes_overTime <-
function(FILEPATH,SAMPLESIZES,NUMSUBSETSPERSAMPLESIZE,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,MEASURES,RESULTFILENAME,ALTFILENAME,MEDIANSFILENAME,ATESTRESULTFILENAME,LARGEDIFFINDICATOR,TIMEPOINTS,TIMEPOINTSCALE)
{
	for(k in 1:length(SAMPLESIZES))
	{
		SAMPLEPROCESSING <- SAMPLESIZES[k]

		for(n in 1:length(TIMEPOINTS))
		{
			TIMEPOINTANALYSED<-TIMEPOINTS[n]

			print(paste("Samples: ",SAMPLEPROCESSING," Timepoint: ",TIMEPOINTANALYSED,sep=""))

			# CONSTRUCT THE FILENAME FOR THIS TIMEPOINT
			SIMRESULTFILENAME<-paste(RESULTFILENAME,"_",TIMEPOINTANALYSED,".csv",sep="")
			
			# CONSTRUCT ALTFILENAME IF BEING USED (NOT NULL)
			if(!is.null(ALTFILENAME))
			{
				ALTFILENAME<-paste(ALTFILENAME,"_",TIMEPOINTANALYSED,".csv",sep="")
			}
			
			# Now generate the medians for each of the dummy parameter sets
			for(l in 1:NUMSUBSETSPERSAMPLESIZE)
			{
				FILEDIR<-paste(FILEPATH,"/",SAMPLEPROCESSING,"/",l,"/",sep="")
				MEDIANSFILENAMEFULL<-paste(MEDIANSFILENAME,"_",TIMEPOINTANALYSED,".csv",sep="")
				# Get the median distributions for each subset - in MedianFunctions.R
				getMediansSubset(FILEDIR,SAMPLEPROCESSING,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,MEASURES,SIMRESULTFILENAME,ALTFILENAME,MEDIANSFILENAMEFULL)
			}

			# Process the distributions for this sample size - producing the A-Test result for each subset
			# THIS IS IN FILE RUNATEST.R
			ATESTRESULTFILENAMEFULL<-paste(ATESTRESULTFILENAME,"_",TIMEPOINTANALYSED,".csv",sep="")
			aa_getATestResults(FILEPATH,SAMPLEPROCESSING,NUMSUBSETSPERSAMPLESIZE,MEASURES,MEDIANSFILENAMEFULL,ATESTRESULTFILENAMEFULL)
	
			# Draw the graph for this sample size
			GRAPHOUTPUTNAME<-paste(SAMPLEPROCESSING,"Samples_",TIMEPOINTANALYSED,".pdf",sep="")
			aa_graphATestsForSampleSize(FILEPATH,SAMPLEPROCESSING,MEASURES,NUMSUBSETSPERSAMPLESIZE,LARGEDIFFINDICATOR,ATESTRESULTFILENAMEFULL,
				GRAPHOUTPUTNAME,TIMEPOINTANALYSED,TIMEPOINTSCALE)
		}
	}
}

