\name{Technique 1: Aleatory Analysis At Multiple Timepoints}
\alias{aa_analyse_all_sample_sizes_overTime}
\alias{aa_sampleSizeSummary_overTime}
\alias{aa_graphSampleSizeSummary_overTime}
\title{Aleatory Analysis At Multiple Timepoints}
\description{
This uses the same technique above, and all of the described methods, but analyses simulation results at multiple timepoints in the simulation run.  This may give a better indication of how variance changes throughout the course of a simulation.  Again, you should have chosen the number of runs you wish to compare, and performed the runs as documented in Technique 1 above. This analysis over time method assumes that the result file for each timepoint has the same name (e.g. trackedCells_Close), which has the timepoint at which it was captured appended to it (e.g. trackedCells_Close_12.csv).  It is assumed that the same folder structure is in place as detailed in Technique 1 above, and shown in figure AA_Folder_Struc in the extdata folder of this package, and in the tutorial available on the project website. The package then examines each timepoint in turn, performing the same analyses documented in Technique 1 above, thus producing A-Test statistics for each sample size at that timepoint, and graphs to present these results in an easy to read manner. Focus then is set to the next timepoint, until all have been considered.\cr
\cr
Again there are three methods available. These act as a wrapper for the previous methods. For example, lets say we are analysing the results at 6,12,18,and 24 hours. Thus TIMEPOINTS will be declared as TIMEPOINTS<-c(6,12,18,24). All methods below consider each timepoint in turn, and prepare the input and output file names to suit the methods detailed above . So if our result file name was tracked_Cells_Close, the method appends the timepoint being analysed to this and the names of any output files that are generated. Once this is done, the original method described in the previous technique is called. It may be useful to download the tutorial data to get an idea of the correct format to use in this case.
}
\usage{
aa_analyse_all_sample_sizes_overTime(FILEPATH,SAMPLESIZES,
	NUMSUBSETSPERSAMPLESIZE,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,
	MEASURES,RESULTFILENAME,ALTFILENAME,MEDIANSFILENAME,
	ATESTRESULTFILENAME,LARGEDIFFINDICATOR,TIMEPOINTS,
	TIMEPOINTSCALE)
aa_sampleSizeSummary_overTime(FILEPATH,SAMPLESIZES,MEASURES,
	ATESTRESULTFILENAME,SUMMARYFILENAME,TIMEPOINTS)
aa_graphSampleSizeSummary_overTime(FILEPATH,MEASURES,MAXSAMPLESIZE,
	SMALL,MEDIUM,LARGE,SUMMARYFILENAME,TIMEPOINTS,TIMEPOINTSCALE)

}
\arguments{
  \item{FILEPATH}{Directory where the results of the simulation runs can be found}
  \item{SAMPLESIZES}{The sample sizes chosen (i.e. in our case, this would be an array containing 1,5,50,100,300,800)}
  \item{NUMSUBSETSPERSAMPLESIZE}{The number of subsets for each sample size (i.e in our case, 20)}
  \item{OUTPUTFILECOLSTART}{Column number in the results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates}
  \item{OUTPUTFILECOLEND}{Column number in the results file where the last output measure is}
  \item{MEASURES}{An array containing the names of the simulation output measures to be analysed. For example, in our simulation, we tracked a cells Velocity, Length, Displacement, and Meandering Index.  Our array would contain these four strings}
  \item{RESULTFILENAME}{Name of the simulation results CSV file up to the timepoint (e.g. "trackedCells_Close"). Captured timepoints should all have this filename, followed by "_", then the timepoint as an integer. Then, for example for hour 12, R would look for the file name trackedCells_Close_12.csv}
  \item{ALTFILENAME}{In some cases, it may be relevant to read from a further results file if the initial file contains no results. This filename is set here. Again leave off any extension and the timepoint}
  \item{MEDIANSFILENAME}{A name for the files generated by aa_analyse_all_sample_sizes_overTime, which contain the results of median of each output measure for every run performed in the subset. (e.g. Medians).  For example, where the sample size is 5, each of the 20 subsets will contain 5 runs.  aa_analyse_all_sample_sizes creates a file within each of the 20 subsets, containing the median output measures from each of the 5 runs.  In this case, as multiple timepoints are being considered, leave off the extension, as the timepoint will be added (e.g. Medians_12.csv for 12 hours)}
  \item{ATESTRESULTFILENAME}{Name of the file contained within each sample size which contains the A-Test results for each of the 20 subsets (created by aa_analyse_all_sample_sizes). Note no extension, as the timepoint is added to the file name (so, this could be set to ATests, the algorithm will then output results for, say 12 hours, as ATests_12.csv)}
  \item{SUMMARYFILENAME}{Name of the file generated by aa_sampleSizeSummary, listing the A-Test results for each sample size. Example - ATestsMaxAndMedians - again the timepoint is appended}
  \item{LARGEDIFFINDICATOR}{The A-Test determines there is a large difference between two sets if the result is greater than 0.2 either side of the 0.5 line.  Should this not be suitable, this can be changed here}
  \item{TIMEPOINTS}{A list of the simulation timepoints which are to be analysed}
  \item{TIMEPOINTSCALE}{A string detailing how TIMEPOINTS should be interpreted (e.g. this could be "Seconds", "Minutes", "Hours", or simply "Simulation Steps"). Used in graphing}
  \item{MAXSAMPLESIZE}{The highest number of samples used.  In our example case, this would be set to 800}
  \item{SMALL}{The figure (>0.5) which is deemed a 'small difference' between two sets being compared.  Vargha-Delaney set this value to 0.56 - but this can be altered here}
  \item{MEDIUM}{The figure (>0.5) which is deemed a 'medium difference' between two sets being compared.  Vargha-Delaney set this value to 0.66 - but this can be altered here}
  \item{LARGE}{The figure (>0.5) which is deemed a 'large difference' between two sets being compared.  Vargha-Delaney set this value to 0.73 - but this can be altered here}
}

\references{This technique is described by Read et al (2012) in their paper: Techniques for Grounding Agent-Based Simulations in the Real Domain: a case study in Experimental Autoimmune Encephalomyelitis."  The A-Test is described by by Vargha & Delaney (2000): "A critique and improvement of the CL Common Language Effect Size Statistics of McGraw and Wong"}

\examples{
# THE CODE IN THIS EXAMPLE IS THE SAME AS THAT USED IN THE TUTORIAL, AND
# THUS YOU NEED TO DOWNLOAD THE TUTORIAL DATA SET AND SET FILEPATH
# CORRECTLY TO RUN THIS

##---- Firstly, declare the parameters required for the four functions ----
# A - DIRECTORY WHERE THE BATCH RUN SAMPLE SETS HAVE ALL BEEN STORED
FILEPATH = "/media/FreeAgent/package_Test_Data/AA/"
# B - SAMPLE SIZES TO ANALYSE
SAMPLESIZES <- c(1,5,50,100,300)
# C- OUTPUT MEASURES
MEASURES<-c("Velocity","Displacement")
# D - NUMBER OF SUBSETS FOR EACH SAMPLE SIZE
NUMSUBSETSPERSAMPLESIZE<-20
# E - THE FILE NAME OF THE RESULTS FILE AND ALTERNATIVE RESULTS
# FILE (IF NECESSARY) - LEAVE OFF EXTENSION
RESULTFILENAME<-"trackedCells_Close"
ALTFILENAME<-NULL
# F - NAME OF THE FILE CONTAINING THE MEDIAN OUTPUT VALUE MEASURES OF 
# EACH RUN IN THE SUBSET - LEAVE OFF EXTENSION
MEDIANSFILENAME<-"EgSet_Medians_Over_Time"
# G - WHAT THE A-TEST RESULTS FILE FOR EACH SAMPLE SIZE SHOULD BE CALLED
# AGAIN LEAVE OFF EXTENSION
ATESTRESULTFILENAME<-"EgSet_ATests_Over_Time"
# H - WHAT THE FILE SUMMARISING A-TEST SCORES FOR ALL SAMPLE SIZES SHOULD
# BE CALLED - LEAVE OFF EXTENSION
SUMMARYFILENAME<-"EgSet_ATestMaxAndMedians_Over_Time"
# I - WHAT IS CONSIDERED A 'LARGE DIFFERENCE' FOR THE A-TEST PARAMETER
# GRAPHS (EITHER SIDE OF 0.5)
LARGEDIFFINDICATOR<-0.23
# J & K - COLUMNS IN RESULTS FILE WHERE THE OUTPUT MEASURES ARE
# SAVES READING IN ALL FILE, AND POTENTIAL SLIP UPS IF COL1 IS ALL THE
# SAME (i.e A CELL LABEL)
OUTPUTFILECOLSTART<-10
OUTPUTFILECOLEND<-11
# L,M,N - WHAT TO CONSIDER SMALL, MEDIUM, AND LARGE DIFFERENCES ON THE
# REDUCED GRAPH
SMALL<-0.56
MEDIUM<-0.66
LARGE<-0.73
# L: TIMEPOINTS TO ANALYSE
TIMEPOINTS<-c(12,36,48,60)
TIMEPOINTSCALE<-"Hours"

# NOW RUN THE METHODS

\dontrun{
# DONTRUN IS SET SO THIS IS NOT EXECUTED WHEN PACKAGE IS COMPILED - BUT THIS
# HAS BEEN TESTED WITH THE TUTORIAL DATA

# A - Calculate the medians & A-Test Files/Graphs for each subset of each
# sample size
aa_analyse_all_sample_sizes_overTime(FILEPATH,SAMPLESIZES,
	NUMSUBSETSPERSAMPLESIZE,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,
	MEASURES,RESULTFILENAME,ALTFILENAME,MEDIANSFILENAME,
	ATESTRESULTFILENAME,LARGEDIFFINDICATOR,TIMEPOINTS,
	TIMEPOINTSCALE)

# B - NOW DO THE SUMMARY FOR EACH SAMPLE SIZE
aa_sampleSizeSummary_overTime(FILEPATH,SAMPLESIZES,MEASURES,
	ATESTRESULTFILENAME,SUMMARYFILENAME,TIMEPOINTS)

# C - GRAPH THE RESULTS FOR ALL SAMPLE SIZES
aa_graphSampleSizeSummary_overTime(FILEPATH,MEASURES,300,
	SMALL,MEDIUM,LARGE,SUMMARYFILENAME,TIMEPOINTS,TIMEPOINTSCALE)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Aleatory}
\keyword{Analysis}
\keyword{Timepoints}
