% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.gee.1subgroup.R
\name{n.gee.1subgroup}
\alias{n.gee.1subgroup}
\title{Sample Size estimation for longitudinal GEE Models when testing 1 coefficient}
\source{
\code{n.gee.1subgroup} uses code contributed by Roland Gerard Gera.
}
\usage{
n.gee.1subgroup(alpha, tail = "both", beta = NULL, delta, sigma,
  tau = 0.5, k = 1, npow = NULL, nmax = Inf)
}
\arguments{
\item{alpha}{level (type I error) to which the hypothesis is tested.}

\item{tail}{which type of test is used, e.g. which quartile und H0 is calculated}

\item{beta}{type II error (power=1-beta) to which an alternative should be proven.}

\item{delta}{vector of regression coefficients values which shall be proven, c(allcomers, subpopulation).}

\item{sigma}{vector of assymptotic standard diviation of regressors, c(full population, subpopulation).see 'Details'}

\item{tau}{subgroup prevalence.}

\item{k}{sample size allocation factor between control and treatment: see 'Details'.}

\item{npow}{calculates power of a test if \code{npow} is a sample size}

\item{nmax}{maximum total sample size.}
}
\value{
\code{n.gee.1subgroup} returns the required sample size within the control group and treatment group.
}
\description{
\code{n.gee.1subgroup} calculates the required sample size for proving a desired alternative when testing regression coefficients in the full or subpopulation. See 'Details' for more information.
}
\details{
This function performs sample size estimation in a design with a subgroup nested within a full population. To calculate the required sample size when testing only one regressor (e.g. effect of treatment*time) one needs to input the expected value of the regressor under alternative, \code{delta}, and the expected asymptotic variance of that regressor, \code{sigma}. 
The power for the global null hypothesis is given by 1-\code{beta} and \code{alpha} specifies the false positve level for rejecting \eqn{H_0: \Delta_F=\Delta_S=0} to level \code{alpha}, where in our context \eqn{\Delta_F and \Delta_S} normaly represent regressioncoefficents and \eqn{\sigma^2} their variance.

For sample sizes \eqn{n_C} and \eqn{n_T} of the control and treatment group, respectively, the argument \code{k} is the
sample size allocation factor, i.e. \eqn{k = n_T/n_C}.
}
\examples{
#Calculate required sample size to correctly reject with
#80\% probability when testing the global Nullhypothesis H_0: Delta_F=Delta_S = 0
#assuming the coefficient in and outside of the subgroup is Delta=c(0.1,0,1) with a 
#subgroup-prevalence of tau=0.4.
#The assymptotic variances in and outside of the subgroup are unequal, sigma=c(0.8,0.4).

estimate<-n.gee.1subgroup(alpha=0.05,beta=0.2,delta=c(0.1,0.1),sigma=c(0.8,0.4),tau=0.4, k=1)
summary(estimate)

#Now we want to estimate the power our study would have, 
#if we know the effect in and outside the subgroup, as 
#well as asymptotic variance of the regressors. Here we 
#estimate that only 300 Patiens total can be recruited.
#All other parameters are the same as those above. 


n.gee.1subgroup(alpha=0.05,delta=c(0.1,0.1),sigma=c(0.8,0.4),tau=0.4, k=1, npow=300)
}
\seealso{
\code{\link{bssr.1subgroup}} for blinded sample size reestimation within a running trial and \code{\link{sandwich}} for estimating asymptotic covarianc mtrices in GEE models.
}

