% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/land.metrics.R
\name{land.metrics}
\alias{land.metrics}
\title{Landscape metrics for points and polygons}
\usage{
land.metrics(x, y, bkgd = NA, metrics = c(4, 14, 33, 34, 35, 37, 38),
  bw = 1000, latlon = FALSE, Trace = TRUE)
}
\arguments{
\item{x}{SpatalPointsDataFrame or SpatalPolgonsDataFrame class object}

\item{y}{raster class object (binary raster)}

\item{bkgd}{Background value}

\item{metrics}{Numeric index of desired metric (see available metrics)}

\item{bw}{Buffer distance (ignored if x is SpatalPolgonsDataFrame)}

\item{latlon}{Is raster data in lat-long (TRUE/FALSE)}

\item{Trace}{Plot raster subsets and echo object ID at each iteration (TRUE | FALSE)}
}
\value{
data.frame with specified metrics in columns. The data.frame is ordered the same as the input feature class and can be directly joined to the @data slot
}
\description{
Calculates a variety of landscape metrics, on binary rasters, for polygons or points with a buffer distance
}
\note{
[1]class, [2]n.patches, [3]total.area, [4]prop.landscape
 [5]patch.density, [6]total.edge, [7]edge.density, [8]landscape.shape.index
 [9]largest.patch.index, [10]mean.patch.area, [11]sd.patch.area, [12]min.patch.area
 [13]max.patch.area, [14]perimeter.area.frac.dim, [15]mean.perim.area.ratio, [16]sd.perim.area.ratio
 [17]min.perim.area.ratio, [18]max.perim.area.ratio, [19]mean.shape.index, [20]sd.shape.index
 [21]min.shape.index, [22]max.shape.index, [23]mean.frac.dim.index, [24]sd.frac.dim.index
 [25]min.frac.dim.index, [26]max.frac.dim.index, [27]total.core.area, [28]prop.landscape.core
 [29]mean.patch.core.area, [30]sd.patch.core.area, [31]min.patch.core.area, [32]max.patch.core.area
 [33]prop.like.adjacencies, [34]aggregation.index, [35]lanscape.division.index, [36]splitting.index
 [37]effective.mesh.size, [38]patch.cohesion.index

depends: sp, raster, rgeos, SDMTools
}
\examples{
library(raster)
library(sp)
r <- raster(ncol=1000, nrow=1000)
  r[] <- rpois(ncell(r), lambda=1)
    r <- calc(r, fun=function(x) { x[x >= 1] <- 1; return(x) } )
x <- sampleRandom(r, 10, na.rm = TRUE, sp = TRUE)

land.metrics(x=x, y=r, bw=0.72, bkgd = 0, latlon = TRUE, Trace = FALSE)
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

