% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dahi.R
\name{dahi}
\alias{dahi}
\title{Diurnal Anisotropic Heat Index}
\usage{
dahi(x, amax = 202.5)
}
\arguments{
\item{x}{An elevation raster of class RasterLayer, SpatRaster or 
SpatialPixelsDataFrame}

\item{amax}{The Alpha Max (amax) parameter in degrees defined 
as: minimum = 0, maximum = 360 with the default = 202.500}
}
\value{
RasterLayer class object Diurnal Anisotropic Heat Index
}
\description{
Simple approximation of the anisotropic diurnal heat (Ha) distribution

The Diurnal Anisotropic Heat Index is based on this equation.  
Ha = cos(amax - a) * arctan(b)
  Where; amax defines the aspect with the maximum total heat  
  surplus, a is the aspect and b is the slope angle.
}
\examples{
library(raster)
data(elev)
Ha <- dahi(elev)
  plot(Ha)

}
\references{
Boehner, J., and Antonic, O. (2009) Land-surface parameters specific to 
   topo-climatology. In: Hengl, T., & Reuter, H. (Eds.), Geomorphometry -
   Concepts, Software, Applications. Developments in Soil Science, 
   33:195-226
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
