% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_samplesizes.r
\name{plot_samplesizes}
\alias{plot_samplesizes}
\title{Plot sample sizes}
\usage{
plot_samplesizes(df, desc = FALSE)
}
\arguments{
\item{df}{a data frame resulting from \code{run_specs()}.}

\item{desc}{logical value indicating whether the curve should the arranged in a descending order. Defaults to FALSE.}
}
\value{
a \link[ggplot2]{ggplot} object.
}
\description{
This function plots a histogram of sample sizes per specification. It can be added to the overall specification curve plot (see vignettes).
}
\examples{
# load additional library
library(ggplot2) # for further customization of the plots

# run specification curve analysis
results <- run_specs(df = example_data,
                     y = c("y1", "y2"),
                     x = c("x1", "x2"),
                     model = c("lm"),
                     controls = c("c1", "c2"),
                     subsets = list(group1 = unique(example_data$group1),
                                    group2 = unique(example_data$group2)))
# plot ranked bar chart of sample sizes
plot_samplesizes(results)

# customize
plot_samplesizes(results) +
  geom_hline(yintercept = median(results$obs),
             color = "darkgrey",
             linetype = "dashed") +
  theme_linedraw()
}
