% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as.spectra}
\alias{as.spectra}
\title{Convert matrix or data frame to spectra}
\usage{
as.spectra(x, name_idx = NULL, meta_idxs = NULL)
}
\arguments{
\item{x}{matrix or dataframe. Samples are in rows and bands in columns.
Any data that are not the spectra themselves (labels or metadata)
must have their column index included in `name_idx` or `meta_idxs`.}

\item{name_idx}{column index with sample names. Defaults to NULL. If NULL
or 0, rownames(x) or a sequence of integers will be assigned
as names.}

\item{meta_idxs}{column indices with metadata (not name and not value).
Defaults to NULL}
}
\value{
spectra object
}
\description{
Convert matrix or data frame to spectra
}
\examples{
library(spectrolab)
as.spectra(spec_matrix_example, name_idx = 1)
}
\author{
Jose Eduardo Meireles
}
