/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.accept;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.AbstractAcceptance;
import bibliothek.gui.dock.accept.DockAcceptance;

public class CombinatoryAcceptance
extends AbstractAcceptance {
    private Combination combination;
    private DockAcceptance first;
    private DockAcceptance second;

    public CombinatoryAcceptance(Combination combination, DockAcceptance dockAcceptance, DockAcceptance dockAcceptance2) {
        this.setCombination(combination);
        this.setFirst(dockAcceptance);
        this.setSecond(dockAcceptance2);
    }

    public boolean accept(DockStation dockStation, Dockable dockable) {
        return this.compare(this.first.accept(dockStation, dockable), this.second.accept(dockStation, dockable));
    }

    public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        return this.compare(this.first.accept(dockStation, dockable, dockable2), this.second.accept(dockStation, dockable, dockable2));
    }

    protected boolean compare(boolean bl, boolean bl2) {
        switch (this.combination) {
            case AND: {
                return bl && bl2;
            }
            case OR: {
                return bl || bl2;
            }
            case XOR: {
                return bl != bl2;
            }
            case EQUAL: {
                return bl == bl2;
            }
            case IMPLIES: {
                return bl2 || !bl;
            }
        }
        throw new IllegalStateException("no combination");
    }

    public void setCombination(Combination combination) {
        if (combination == null) {
            throw new IllegalArgumentException("Combination must not be null");
        }
        this.combination = combination;
    }

    public Combination getCombination() {
        return this.combination;
    }

    public void setFirst(DockAcceptance dockAcceptance) {
        if (dockAcceptance == null) {
            throw new IllegalArgumentException("First must not be null");
        }
        this.first = dockAcceptance;
    }

    public DockAcceptance getFirst() {
        return this.first;
    }

    public void setSecond(DockAcceptance dockAcceptance) {
        if (dockAcceptance == null) {
            throw new IllegalArgumentException("Second must not be null");
        }
        this.second = dockAcceptance;
    }

    public DockAcceptance getSecond() {
        return this.second;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Combination {
        AND,
        OR,
        XOR,
        EQUAL,
        IMPLIES;

    }
}

