/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Comparable<Version> {
    public static final Version VERSION_1_0_4 = new Version(1, 0, 4, null);
    public static final Version VERSION_1_0_5 = new Version(1, 0, 5, null);
    public static final Version VERSION_1_0_6 = new Version(1, 0, 6, null);
    public static final Version VERSION_1_0_7 = new Version(1, 0, 7, null);
    public static final Version VERSION_1_0_8 = new Version(1, 0, 8, null);
    public static final Version VERSION_1_0_8a;
    public static final Version CURRENT;
    private int major;
    private int minor;
    private int mikro;
    private String add;

    public Version(int n, int n2, int n3, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("major must not be smaller than 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("minor must not be smaller than 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("mikro must not be smaller than 0");
        }
        if (string == null) {
            string = "";
        }
        this.major = n;
        this.mikro = n3;
        this.minor = n2;
        this.add = string;
    }

    public static void write(DataOutputStream dataOutputStream, Version version) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(version.major);
        dataOutputStream.writeInt(version.minor);
        dataOutputStream.writeInt(version.mikro);
        dataOutputStream.writeUTF(version.add);
    }

    public static Version read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by != 1) {
            throw new IOException("Unknown format for version");
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        return new Version(n, n2, n3, string);
    }

    public void checkCurrent() throws IOException {
        if (this.compareTo(CURRENT) > 0) {
            throw new IOException("Trying to read something from the future: " + this + " is greater than the current version " + CURRENT);
        }
    }

    public String getAdd() {
        return this.add;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMikro() {
        return this.mikro;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(Version version) {
        if (this.major > version.major) {
            return 1;
        }
        if (this.major < version.major) {
            return -1;
        }
        if (this.minor > version.minor) {
            return 1;
        }
        if (this.minor < version.minor) {
            return -1;
        }
        if (this.mikro > version.mikro) {
            return 1;
        }
        if (this.mikro < version.mikro) {
            return -1;
        }
        return this.add.compareTo(version.add);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.mikro + this.add;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.add == null ? 0 : this.add.hashCode());
        n = 31 * n + this.major;
        n = 31 * n + this.mikro;
        n = 31 * n + this.minor;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        if (this.add == null ? version.add != null : !this.add.equals(version.add)) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        if (this.mikro != version.mikro) {
            return false;
        }
        return this.minor == version.minor;
    }

    static {
        CURRENT = VERSION_1_0_8a = new Version(1, 0, 8, "a");
    }
}

