/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class TabColorTransmitter
extends ColorTransmitter {
    private ColorManager manager;
    private String[] keys;

    public TabColorTransmitter(ColorManager colorManager, String ... stringArray) {
        super(stringArray);
        this.keys = stringArray;
        this.manager = colorManager;
    }

    protected abstract Color convert(Color var1, String var2);

    protected abstract Color convertSelected(Color var1, String var2);

    protected abstract Color convertFocused(Color var1, String var2);

    protected Color get(Color color, String string, DockColor dockColor) {
        CDockable cDockable = this.getDockable(dockColor);
        if (cDockable != null) {
            return this.get(color, string, cDockable);
        }
        return color;
    }

    protected abstract boolean isForeground(String var1);

    protected abstract boolean isSelected(String var1);

    protected abstract boolean isFocused(String var1);

    protected Color get(Color color, String string, CDockable cDockable) {
        Color color2 = null;
        ColorMap colorMap = cDockable.getColors();
        boolean bl = this.isForeground(string);
        boolean bl2 = this.isSelected(string);
        boolean bl3 = this.isFocused(string);
        if (bl) {
            if (bl3) {
                color2 = colorMap.getColor("tab.foreground.focused");
            }
            if (color2 == null && (bl3 || bl2)) {
                color2 = colorMap.getColor("tab.foreground.selected");
            }
            if (color2 == null) {
                color2 = colorMap.getColor("tab.foreground");
            }
        }
        if (color2 == null) {
            if (bl3 && (color2 = colorMap.getColor("tab.background.focused")) != null) {
                color2 = this.convertFocused(color2, string);
            }
            if (color2 == null && (bl3 || bl2) && (color2 = colorMap.getColor("tab.background.selected")) != null) {
                color2 = this.convertSelected(color2, string);
            }
            if (color2 == null && (color2 = colorMap.getColor("tab.background")) != null) {
                color2 = this.convert(color2, string);
            }
        }
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    protected void update(CDockable cDockable, String string, Color color) {
        boolean bl;
        boolean bl2 = bl = "tab.background".equals(string) || "tab.background.focused".equals(string) || "tab.background.selected".equals(string) || "tab.foreground".equals(string) || "tab.foreground.focused".equals(string) || "tab.foreground.selected".equals(string);
        if (bl) {
            for (String string2 : this.keys) {
                this.set(string2, this.get((Color)this.manager.get(string2), string2, cDockable), cDockable);
            }
        }
    }

    protected CDockable getDockable(DockColor dockColor) {
        Dockable dockable = ((TabColor)dockColor).getDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }
}

