/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModeManager<H, M extends Mode<H>> {
    private List<ModeHandle> modes = new ArrayList<ModeHandle>();
    private Map<Path, ModeSettingFactory<H>> factories = new HashMap<Path, ModeSettingFactory<H>>();
    private Map<Dockable, DockableHandle> dockables = new HashMap<Dockable, DockableHandle>();
    private Map<String, DockableHandle> entries = new HashMap<String, DockableHandle>();
    private List<ModeManagerListener<? super H, ? super M>> listeners = new ArrayList<ModeManagerListener<? super H, ? super M>>();
    private int onTransaction = 0;
    private int onContinuous = 0;
    private DockController controller;
    private ChangeSet affected;
    private int affectedCount = 0;
    private ActionGuard guard = new ActionGuard(){

        public boolean react(Dockable dockable) {
            return ModeManager.this.getHandle(dockable) != null;
        }

        public DockActionSource getSource(Dockable dockable) {
            DockableHandle dockableHandle = ModeManager.this.getHandle(dockable);
            if (dockableHandle == null) {
                return null;
            }
            return dockableHandle.source;
        }
    };

    public ModeManager(DockController dockController) {
        dockController.addActionGuard(this.guard);
        this.controller = dockController;
    }

    public void destroy() {
        if (this.controller != null) {
            this.controller.removeActionGuard(this.guard);
            this.controller = null;
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void addModeManagerListener(ModeManagerListener<? super H, ? super M> modeManagerListener) {
        if (modeManagerListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(modeManagerListener);
    }

    public void removeModeManagerListener(ModeManagerListener<? super H, ? super M> modeManagerListener) {
        this.listeners.remove(modeManagerListener);
    }

    public void putMode(M m) {
        if (m == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        for (ModeHandle modeHandle : this.modes) {
            if (!modeHandle.mode.getUniqueIdentifier().equals(m.getUniqueIdentifier())) continue;
            this.fireRemoved(modeHandle.mode);
            modeHandle.mode = m;
            this.fireAdded(m);
            return;
        }
        this.modes.add(new ModeHandle(this, m));
        this.fireAdded(m);
    }

    public void putFactory(ModeSettingFactory<H> modeSettingFactory) {
        this.factories.put(modeSettingFactory.getModeId(), modeSettingFactory);
    }

    public void removeMode(M m) {
        if (m == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        for (ModeHandle modeHandle : this.modes) {
            if (!modeHandle.mode.getUniqueIdentifier().equals(m.getUniqueIdentifier())) continue;
            modeHandle.mode = null;
            this.fireRemoved(modeHandle.mode);
            this.modes.remove(modeHandle);
            return;
        }
    }

    public M getMode(Path path) {
        ModeHandle modeHandle = this.getAccess(path);
        return (M)(modeHandle == null ? null : modeHandle.mode);
    }

    private ModeHandle getAccess(Path path) {
        for (ModeHandle modeHandle : this.modes) {
            if (!modeHandle.mode.getUniqueIdentifier().equals(path)) continue;
            return modeHandle;
        }
        return null;
    }

    protected ModeManagerListener<? super H, ? super M>[] listeners() {
        return this.listeners.toArray(new ModeManagerListener[this.listeners.size()]);
    }

    protected void fireAdded(Dockable dockable) {
        for (ModeManagerListener<H, M> modeManagerListener : this.listeners()) {
            modeManagerListener.dockableAdded(this, dockable);
        }
    }

    protected void fireRemoved(Dockable dockable) {
        for (ModeManagerListener<H, M> modeManagerListener : this.listeners()) {
            modeManagerListener.dockableRemoved(this, dockable);
        }
    }

    protected void fireModeChanged(Dockable dockable, M m, M m2) {
        for (ModeManagerListener<H, M> modeManagerListener : this.listeners()) {
            modeManagerListener.modeChanged(this, dockable, m, m2);
        }
    }

    protected void fireAdded(M m) {
        for (ModeManagerListener<H, M> modeManagerListener : this.listeners()) {
            modeManagerListener.modeAdded(this, m);
        }
    }

    protected void fireRemoved(M m) {
        for (ModeManagerListener<H, M> modeManagerListener : this.listeners()) {
            modeManagerListener.modeRemoved(this, m);
        }
    }

    public void add(String string, Dockable dockable) {
        if (string == null) {
            throw new NullPointerException("key must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableHandle dockableHandle = this.entries.get(string);
        if (dockableHandle != null && dockableHandle.dockable != null) {
            throw new IllegalArgumentException("There is already a dockable registered with the key: " + string);
        }
        if (dockableHandle == null) {
            dockableHandle = new DockableHandle(dockable, string);
            this.entries.put(dockableHandle.id, dockableHandle);
        } else {
            dockableHandle.dockable = dockable;
        }
        this.dockables.put(dockable, dockableHandle);
        dockableHandle.putMode(this.access(this.getCurrentMode(dockable)));
        this.fireAdded(dockable);
        this.rebuild(dockable);
    }

    public void put(String string, Dockable dockable) {
        if (string == null) {
            throw new NullPointerException("key must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableHandle dockableHandle = this.entries.get(string);
        if (dockableHandle != null) {
            if (dockableHandle.dockable != null) {
                this.dockables.remove(dockableHandle.dockable);
                this.fireRemoved(dockableHandle.dockable);
            }
            dockableHandle.dockable = dockable;
            this.dockables.put(dockable, dockableHandle);
        } else {
            dockableHandle = new DockableHandle(dockable, string);
            this.dockables.put(dockable, dockableHandle);
            this.entries.put(dockableHandle.id, dockableHandle);
            dockableHandle.putMode(this.access(this.getCurrentMode(dockable)));
        }
        this.fireAdded(dockable);
        this.rebuild(dockable);
    }

    public String getKey(Dockable dockable) {
        DockableHandle dockableHandle = this.getHandle(dockable);
        if (dockableHandle == null) {
            return null;
        }
        return dockableHandle.id;
    }

    public boolean isRegistered(Dockable dockable) {
        return this.getKey(dockable) != null;
    }

    public Set<Dockable> listDockables() {
        return Collections.unmodifiableSet(this.dockables.keySet());
    }

    public void runTransaction(AffectingRunnable affectingRunnable) {
        this.runTransaction(affectingRunnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(final AffectingRunnable affectingRunnable, boolean bl) {
        if (affectingRunnable == null) {
            return;
        }
        try {
            this.openAffected();
            this.runTransaction(new Runnable(){

                public void run() {
                    affectingRunnable.run(ModeManager.this.affected);
                }
            }, bl);
        }
        finally {
            this.closeAffected();
        }
    }

    public void runTransaction(Runnable runnable) {
        this.runTransaction(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(Runnable runnable, boolean bl) {
        try {
            this.controller.getRegister().setStalled(true);
            ++this.onTransaction;
            if (bl) {
                ++this.onContinuous;
            }
            runnable.run();
        }
        finally {
            this.controller.getRegister().setStalled(false);
            --this.onTransaction;
            if (bl) {
                --this.onContinuous;
            }
        }
    }

    public boolean apply(Dockable dockable, Path path, boolean bl) {
        M m = this.getMode(path);
        if (m != null) {
            this.apply(dockable, m, bl);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Dockable dockable, M m, boolean bl) {
        try {
            this.openAffected();
            this.apply(dockable, m, (AffectedSet)this.affected, bl);
        }
        finally {
            this.closeAffected();
        }
    }

    public boolean apply(Dockable dockable, Path path, AffectedSet affectedSet, boolean bl) {
        M m = this.getMode(path);
        if (m != null) {
            this.apply(dockable, m, affectedSet, bl);
            return true;
        }
        return false;
    }

    public void apply(Dockable dockable, M m, AffectedSet affectedSet, boolean bl) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (m == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (affectedSet == null) {
            throw new IllegalArgumentException("set is null");
        }
        DockableHandle dockableHandle = this.dockables.get(dockable);
        if (dockableHandle == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        M m2 = this.getCurrentMode(dockable);
        if (!bl && m2 == m) {
            return;
        }
        Object h = dockableHandle.properties.get(m.getUniqueIdentifier());
        this.apply(dockable, m, h, affectedSet);
    }

    public boolean apply(Dockable dockable, Path path, H h, AffectedSet affectedSet) {
        M m = this.getMode(path);
        if (m != null) {
            this.apply(dockable, m, h, affectedSet);
            return true;
        }
        return false;
    }

    public void apply(Dockable dockable, M m, H h, AffectedSet affectedSet) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (m == null) {
            throw new IllegalArgumentException("mode is null");
        }
        if (affectedSet == null) {
            throw new IllegalArgumentException("set is null");
        }
        M m2 = this.getCurrentMode(dockable);
        if (m2 != null) {
            this.store(dockable);
        }
        affectedSet.add(dockable);
        this.runTransaction(new Runnable((Mode)m, dockable, h, affectedSet){
            final /* synthetic */ Mode val$mode;
            final /* synthetic */ Dockable val$dockable;
            final /* synthetic */ Object val$history;
            final /* synthetic */ AffectedSet val$set;
            {
                this.val$mode = mode;
                this.val$dockable = dockable;
                this.val$history = object;
                this.val$set = affectedSet;
            }

            public void run() {
                this.val$mode.apply(this.val$dockable, this.val$history, this.val$set);
            }
        });
    }

    protected void setProperties(M m, Dockable dockable, H h) {
        DockableHandle dockableHandle = this.dockables.get(dockable);
        if (dockableHandle != null) {
            if (h == null) {
                dockableHandle.properties.remove(m.getUniqueIdentifier());
            } else {
                dockableHandle.properties.put(m.getUniqueIdentifier(), h);
            }
        }
    }

    protected H getProperties(M m, Dockable dockable) {
        DockableHandle dockableHandle = this.dockables.get(dockable);
        if (dockableHandle == null) {
            return null;
        }
        return dockableHandle.properties.get(m.getUniqueIdentifier());
    }

    public boolean isOnTransaction() {
        return this.onTransaction > 0;
    }

    public boolean isOnContinuous() {
        return this.onContinuous > 0;
    }

    public void refresh() {
        for (Dockable dockable : this.dockables.keySet()) {
            this.refresh(dockable, false);
        }
    }

    public void refresh(Dockable dockable, boolean bl) {
        DockStation dockStation;
        DockableHandle dockableHandle = this.getHandle(dockable);
        if (dockableHandle != null) {
            dockableHandle.putMode(this.access(this.getCurrentMode(dockable)));
        }
        if (bl && (dockStation = dockable.asDockStation()) != null) {
            int n = dockStation.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.refresh(dockStation.getDockable(i), bl);
            }
        }
    }

    public void remove(Dockable dockable) {
        DockableHandle dockableHandle = this.dockables.remove(dockable);
        if (dockableHandle != null) {
            if (!dockableHandle.empty) {
                this.entries.remove(dockableHandle.id);
            }
            this.fireRemoved(dockable);
        }
    }

    public void reduceToEmpty(Dockable dockable) {
        DockableHandle dockableHandle = this.dockables.get(dockable);
        if (dockableHandle != null) {
            dockableHandle.dockable = null;
            this.fireRemoved(dockable);
        }
    }

    protected abstract void applyDuringRead(String var1, Path var2, Path var3, Dockable var4);

    protected boolean createEntryDuringRead(String string) {
        return false;
    }

    public void addEmpty(String string) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        DockableHandle dockableHandle = this.entries.get(string);
        if (dockableHandle == null) {
            dockableHandle = new DockableHandle(null, string);
            this.entries.put(string, dockableHandle);
        }
        dockableHandle.empty = true;
    }

    public void removeEmpty(String string) {
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        DockableHandle dockableHandle = this.entries.get(string);
        if (dockableHandle != null) {
            dockableHandle.empty = false;
            if (dockableHandle.dockable == null) {
                this.entries.remove(string);
            }
        }
    }

    public boolean isEmpty(String string) {
        DockableHandle dockableHandle = this.entries.get(string);
        return dockableHandle != null && dockableHandle.empty;
    }

    public Dockable getDoubleClickTarget(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        if (this.dockables.get(dockable) != null) {
            return dockable;
        }
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            return null;
        }
        return this.getDoubleClickTarget(dockStation.getFrontDockable());
    }

    protected M getDefaultMode(Dockable dockable) {
        if (this.modes.isEmpty()) {
            throw new IllegalStateException("no modes available");
        }
        for (ModeHandle modeHandle : this.modes) {
            if (!modeHandle.mode.isDefaultMode(dockable)) continue;
            return (M)modeHandle.mode;
        }
        throw new IllegalStateException("no mode is the default mode for '" + dockable.getTitleText() + "'");
    }

    public M getCurrentMode(Dockable dockable) {
        for (ModeHandle modeHandle : this.modes) {
            if (!modeHandle.mode.isCurrentMode(dockable)) continue;
            return (M)modeHandle.mode;
        }
        return null;
    }

    public M getPreviousMode(Dockable dockable) {
        DockableHandle dockableHandle = this.getHandle(dockable);
        if (dockableHandle == null) {
            return null;
        }
        ModeHandle modeHandle = dockableHandle.previousMode();
        if (modeHandle == null) {
            return null;
        }
        return (M)modeHandle.mode;
    }

    public List<M> getModeHistory(Dockable dockable) {
        DockableHandle dockableHandle = this.getHandle(dockable);
        if (dockableHandle == null) {
            return Collections.emptyList();
        }
        ArrayList<M> arrayList = new ArrayList<M>();
        for (Path path : dockableHandle.history) {
            M m = this.getMode(path);
            if (m == null) continue;
            arrayList.add(m);
        }
        return arrayList;
    }

    public List<H> getPropertyHistory(Dockable dockable) {
        DockableHandle dockableHandle = this.getHandle(dockable);
        if (dockableHandle == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        for (Path path : dockableHandle.history) {
            Object h = dockableHandle.properties.get(path);
            if (h == null) continue;
            arrayList.add(h);
        }
        return arrayList;
    }

    public void store(Dockable dockable) {
        if (this.isOnContinuous()) {
            return;
        }
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                Object m = ModeManager.this.getCurrentMode(dockable);
                if (m != null) {
                    ModeManager.this.store(m, dockable);
                }
            }
        });
    }

    protected void store(M m, Dockable dockable) {
        if (this.isOnContinuous()) {
            return;
        }
        DockableHandle dockableHandle = this.getHandle(dockable);
        if (dockableHandle != null) {
            dockableHandle.properties.put(m.getUniqueIdentifier(), m.current(dockable));
        }
    }

    private ModeHandle access(M m) {
        if (m == null) {
            return null;
        }
        for (ModeHandle modeHandle : this.modes) {
            if (modeHandle.mode != m) continue;
            return modeHandle;
        }
        throw new IllegalArgumentException("unknown mode: " + m);
    }

    public Iterable<M> modes() {
        return new Iterable<M>(){

            @Override
            public Iterator<M> iterator() {
                final Iterator iterator = ModeManager.this.modes.iterator();
                return new Iterator<M>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public M next() {
                        return ((ModeHandle)iterator.next()).mode;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("cannot remove modes this way");
                    }
                };
            }
        };
    }

    protected void rebuildAll() {
        for (DockableHandle dockableHandle : this.dockables.values()) {
            dockableHandle.updateActionSource();
        }
    }

    protected void rebuild(Dockable dockable) {
        DockableHandle dockableHandle = this.dockables.get(dockable);
        if (dockableHandle != null) {
            dockableHandle.updateActionSource();
        }
    }

    private DockableHandle getHandle(Dockable dockable) {
        return this.dockables.get(dockable);
    }

    public <B> ModeSettings<H, B> createSettings(ModeSettingsConverter<H, B> modeSettingsConverter) {
        ModeSettings<H, B> modeSettings = this.createModeSettings(modeSettingsConverter);
        for (ModeSettingFactory<H> object : this.factories.values()) {
            modeSettings.addFactory(object);
        }
        for (ModeHandle modeHandle : this.modes) {
            ModeSettingFactory modeSettingFactory;
            if (modeHandle.mode == null || (modeSettingFactory = modeHandle.mode.getSettingFactory()) == null) continue;
            modeSettings.addFactory(modeSettingFactory);
        }
        return modeSettings;
    }

    protected <B> ModeSettings<H, B> createModeSettings(ModeSettingsConverter<H, B> modeSettingsConverter) {
        return new ModeSettings<H, B>(modeSettingsConverter);
    }

    public void writeSettings(ModeSettings<H, ?> modeSettings) {
        for (DockableHandle object : this.entries.values()) {
            modeSettings.add(object.id, object.getCurrent(), object.properties, object.history);
        }
        for (ModeHandle modeHandle : this.modes) {
            if (modeHandle.mode == null) continue;
            modeSettings.add(modeHandle.mode);
        }
    }

    public void readSettings(ModeSettings<H, ?> modeSettings) {
        Object object;
        int n = modeSettings.size();
        for (int i = 0; i < n; ++i) {
            Object object2;
            object = modeSettings.getId(i);
            DockableHandle dockableHandle = this.entries.get(object);
            if (dockableHandle == null && this.createEntryDuringRead((String)object)) {
                this.addEmpty((String)object);
                dockableHandle = this.entries.get(object);
            }
            if (dockableHandle == null) continue;
            Path path = modeSettings.getCurrent(i);
            Path path2 = null;
            if (dockableHandle.dockable != null && (object2 = this.getCurrentMode(dockableHandle.dockable)) != null) {
                path2 = object2.getUniqueIdentifier();
            }
            if (path == null) {
                path = path2;
            }
            dockableHandle.history.clear();
            object2 = modeSettings.getHistory(i);
            int n2 = ((M)object2).length;
            for (int j = 0; j < n2; ++j) {
                M m = object2[j];
                dockableHandle.history.add(m);
            }
            dockableHandle.properties = modeSettings.getProperties(i);
            if ((path2 != null || path == null) && (path2 == null || path2.equals(path))) continue;
            this.applyDuringRead((String)object, path2, path, dockableHandle.dockable);
        }
        for (ModeHandle modeHandle : this.modes) {
            if (modeHandle.mode == null || (object = modeSettings.getSettings(modeHandle.mode.getUniqueIdentifier())) == null) continue;
            modeHandle.mode.readSetting(object);
        }
    }

    public void addAffected(Iterable<Dockable> iterable) {
        this.openAffected();
        for (Dockable dockable : iterable) {
            this.affected.add(dockable);
        }
        this.closeAffected();
    }

    private void openAffected() {
        if (this.affectedCount == 0) {
            this.affected = new ChangeSet();
        }
        ++this.affectedCount;
    }

    private void closeAffected() {
        --this.affectedCount;
        if (this.affectedCount == 0) {
            ChangeSet changeSet = this.affected;
            this.affected = null;
            changeSet.finish();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[");
        for (DockableHandle dockableHandle : this.entries.values()) {
            stringBuilder.append("\n\t");
            stringBuilder.append(dockableHandle.id);
            for (Map.Entry entry : dockableHandle.properties.entrySet()) {
                stringBuilder.append("\n\t\t");
                stringBuilder.append(entry.getKey());
                stringBuilder.append(" -> ");
                stringBuilder.append(entry.getValue());
            }
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    private class ChangeSet
    implements AffectedSet {
        private Set<Dockable> set = new HashSet<Dockable>();

        public void add(Dockable dockable) {
            if (dockable != null) {
                this.set.add(dockable);
                DockStation dockStation = dockable.asDockStation();
                if (dockStation != null) {
                    int n = dockStation.getDockableCount();
                    for (int i = 0; i < n; ++i) {
                        this.add(dockStation.getDockable(i));
                    }
                }
            }
        }

        public void finish() {
            for (Dockable dockable : this.set) {
                ModeManager.this.refresh(dockable, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DockableHandle {
        public Dockable dockable;
        public String id;
        public MultiDockActionSource source;
        public Map<Path, H> properties;
        private List<Path> history;
        private boolean empty = false;

        public DockableHandle(Dockable dockable, String string) {
            this.dockable = dockable;
            this.id = string;
            this.source = new MultiDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT), new DockActionSource[0]);
            this.properties = new HashMap();
            this.history = new LinkedList<Path>();
        }

        public void updateActionSource() {
            if (this.dockable != null) {
                this.source.removeAll();
                Object m = ModeManager.this.getCurrentMode(this.dockable);
                if (m == null) {
                    m = ModeManager.this.getDefaultMode(this.dockable);
                }
                for (ModeHandle modeHandle : ModeManager.this.modes) {
                    DockActionSource dockActionSource = modeHandle.mode.getActionsFor(this.dockable, m);
                    if (dockActionSource == null) continue;
                    this.source.add(dockActionSource);
                }
            }
        }

        public void putMode(ModeHandle modeHandle) {
            if (modeHandle != null) {
                ModeHandle modeHandle2 = this.peekMode();
                if (modeHandle2 != modeHandle) {
                    Path path = modeHandle.mode.getUniqueIdentifier();
                    this.history.remove(path);
                    this.history.add(path);
                    this.properties.put(path, modeHandle.mode.current(this.dockable));
                    ModeManager.this.rebuild(this.dockable);
                    ModeManager.this.fireModeChanged(this.dockable, modeHandle2 == null ? null : modeHandle2.mode, modeHandle == null ? null : modeHandle.mode);
                } else {
                    ModeManager.this.rebuild(this.dockable);
                }
            }
        }

        public ModeHandle previousMode() {
            if (this.history.size() < 2) {
                return ModeManager.this.access(ModeManager.this.getDefaultMode(this.dockable));
            }
            return ModeManager.this.getAccess(this.history.get(this.history.size() - 2));
        }

        public ModeHandle peekMode() {
            if (this.history.isEmpty()) {
                return null;
            }
            return ModeManager.this.getAccess(this.history.get(this.history.size() - 1));
        }

        public Path getCurrent() {
            if (this.dockable == null) {
                return null;
            }
            Object m = ModeManager.this.getCurrentMode(this.dockable);
            if (m == null) {
                return null;
            }
            return m.getUniqueIdentifier();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModeHandle {
        private M mode;
        final /* synthetic */ ModeManager this$0;

        public ModeHandle(M m) {
            this.this$0 = var1_1;
            this.mode = m;
        }
    }
}

