/*
 * Decompiled with CFR 0.152.
 */
package test;

import at.ac.ait.dockingframes.theme.AITEclipseTheme;
import at.ac.ait.laf.substance.AITBlackSteelLAF;
import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.theme.CDockThemeFactory;
import bibliothek.gui.dock.common.intern.theme.CEclipseTheme;
import bibliothek.gui.dock.common.layout.ThemeMap;
import bibliothek.gui.dock.common.menu.SingleCDockableListMenuPiece;
import bibliothek.gui.dock.facile.menu.RootMenuPiece;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.util.xml.XElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Dock {
    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    UIManager.setLookAndFeel((LookAndFeel)new AITBlackSteelLAF());
                }
                catch (UnsupportedLookAndFeelException ex) {
                    Logger.getLogger(Dock.class.getName()).log(Level.SEVERE, null, ex);
                }
                JFrame frame = new JFrame("Demo");
                final CControl control = new CControl(frame);
                ThemeMap tm = control.getThemes();
                final AITEclipseTheme theme = new AITEclipseTheme();
                CDockThemeFactory<AITEclipseTheme> arcseclipse = new CDockThemeFactory<AITEclipseTheme>(new ThemePropertyFactory(AITEclipseTheme.class), control){

                    public DockTheme create(CControl control) {
                        return new CEclipseTheme(control, (EclipseTheme)theme);
                    }
                };
                tm.add("KEY_ARCS_THEME", (ThemeFactory)arcseclipse);
                control.setTheme("KEY_ARCS_THEME");
                frame.add((Component)control.getContentArea());
                DefaultSingleCDockable orange = Dock.createDockable("Orange", Color.ORANGE, control);
                orange.setStackable(false);
                orange.setTitleShown(false);
                control.add((SingleCDockable)orange);
                CGrid grid = new CGrid(control);
                grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{Dock.createDockable("Red", Color.RED, control)});
                grid.add(0.0, 1.0, 1.0, 1.0, new CDockable[]{Dock.createDockable("Green", Color.GREEN, control)});
                grid.add(1.0, 0.0, 1.0, 1.0, new CDockable[]{Dock.createDockable("Blue", Color.BLUE, control)});
                grid.add(1.0, 1.0, 1.0, 1.0, new CDockable[]{Dock.createDockable("Yellow", Color.YELLOW, control)});
                control.getContentArea().deploy(grid);
                DefaultSingleCDockable black = Dock.createDockable("Black", Color.BLACK, control);
                control.add((SingleCDockable)black);
                black.setLocation((CLocation)CLocation.base().minimalNorth());
                black.setVisible(true);
                RootMenuPiece menu = new RootMenuPiece("Colors", false, new MenuPiece[0]);
                menu.add((MenuPiece)new SingleCDockableListMenuPiece(control));
                JMenuBar menuBar = new JMenuBar();
                menuBar.add(menu.getMenu());
                menu.getMenu().add(new AbstractAction("Save"){

                    public void actionPerformed(ActionEvent e) {
                        control.save("mylayout");
                        XElement element = new XElement("root");
                        try {
                            control.getResources().writeFile(new File("e:\\downloads\\layout"));
                            control.getResources().writeXML(element);
                            FileWriter fstream = new FileWriter("e:\\downloads\\layout.xml");
                            BufferedWriter out = new BufferedWriter(fstream);
                            out.write(element.toString());
                            out.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Dock.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                menu.getMenu().add(new AbstractAction("Load"){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            control.getResources().readFile(new File("e:\\downloads\\layout"));
                            control.load("mylayout");
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Dock.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                frame.setJMenuBar(menuBar);
                frame.setDefaultCloseOperation(3);
                frame.setBounds(20, 20, 400, 400);
                frame.setVisible(true);
            }
        });
    }

    public static DefaultSingleCDockable createDockable(String title, Color color, CControl control) {
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(title, title, (Component)panel, new CAction[0]);
        dockable.setCloseable(true);
        FontMap map = dockable.getFonts();
        map.setFont("dock.tab", new String[]{"b=!"});
        dockable.setSingleTabShown(false);
        return dockable;
    }
}

