/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CPlaceholderStrategy;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockGrid;
import bibliothek.util.Path;

public class CGrid {
    private SplitDockGrid grid = new SplitDockGrid();
    private CControl control;

    @Deprecated
    public CGrid() {
    }

    public CGrid(CControl control) {
        this.control = control;
    }

    public DockableSplitDockTree toTree() {
        return this.grid.toTree();
    }

    public void add(double x, double y, double width, double height, CDockable ... dockables) {
        Object[] intern = new Dockable[dockables.length];
        for (int i = 0; i < intern.length; ++i) {
            CDockable dockable = dockables[i];
            if (this.control != null) {
                if (dockable instanceof SingleCDockable) {
                    this.control.addDockable((SingleCDockable)dockable);
                } else if (dockable instanceof MultipleCDockable && dockable.getControl() == null) {
                    this.control.addDockable((MultipleCDockable)dockable);
                }
            }
            intern[i] = dockable.intern();
        }
        this.grid.addDockable(x, y, width, height, intern);
    }

    public void addSingle(double x, double y, double width, double height, String ... identifiers) {
        if (this.control == null) {
            throw new IllegalStateException("This method is only available if the CGrid was constructed with a CControl");
        }
        Path[] placeholders = new Path[identifiers.length];
        for (int i = 0; i < placeholders.length; ++i) {
            placeholders[i] = CPlaceholderStrategy.getSingleDockablePlaceholder(this.control.getRegister().toSingleId(identifiers[i]));
        }
    }

    public void addMulti(double x, double y, double width, double height, String ... identifiers) {
        if (this.control == null) {
            throw new IllegalStateException("This method is only available if the CGrid was constructed with a CControl");
        }
        Path[] placeholders = new Path[identifiers.length];
        for (int i = 0; i < placeholders.length; ++i) {
            placeholders[i] = CPlaceholderStrategy.getMultipleDockablePlaceholder(this.control.getRegister().toMultiId(identifiers[i]));
        }
    }

    public void addPlaceholders(double x, double y, double width, double height, Path ... placeholders) {
        this.grid.addPlaceholders(x, y, width, height, placeholders);
    }

    public void select(double x, double y, double width, double height, CDockable dockable) {
        this.grid.setSelected(x, y, width, height, (Object)dockable.intern());
    }

    public void addHorizontalDivider(double x1, double x2, double y) {
        this.grid.addHorizontalDivider(x1, x2, y);
    }

    public void addVerticalDivider(double x, double y1, double y2) {
        this.grid.addVerticalDivider(x, y1, y2);
    }
}

