/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.station.AbstractResizeRequestHandler;
import bibliothek.gui.dock.common.intern.station.CLockedResizeLayoutManager;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import java.awt.Insets;

public class SplitResizeRequestHandler
extends AbstractResizeRequestHandler {
    private SplitDockStation station;

    public SplitResizeRequestHandler(SplitDockStation station) {
        this.station = station;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResizeRequest(CControl control) {
        SplitLayoutManager oldManager = this.station.getSplitLayoutManager();
        LayoutManager layout = new LayoutManager();
        try {
            layout.setControl(control);
            this.station.setSplitLayoutManager((SplitLayoutManager)layout);
            this.station.updateBounds();
        }
        finally {
            layout.setControl(null);
            this.station.setSplitLayoutManager(oldManager);
        }
    }

    private class LayoutManager
    extends CLockedResizeLayoutManager {
        private LayoutManager() {
        }

        public void updateBounds(Root root, double x, double y, double factorW, double factorH) {
            this.updateBoundsLocked(root, x, y, factorW, factorH);
        }

        public RequestDimension prepareResize(Leaf leaf) {
            RequestDimension request = SplitResizeRequestHandler.this.getAndClearResizeRequest(leaf.getDockable());
            if (request != null) {
                Insets insets = leaf.getDisplayer().getDockableInsets();
                if (request.isWidthSet()) {
                    request.setWidth(request.getWidth() + insets.left + insets.right);
                }
                if (request.isHeightSet()) {
                    request.setHeight(request.getHeight() + insets.top + insets.bottom);
                }
                return request;
            }
            return super.prepareResize(leaf);
        }
    }
}

