/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayerCollection
implements Iterable<DockableDisplayer> {
    private DockStation station;
    private DockController controller;
    private DisplayerFactory factory;
    private List<DockableDisplayer> displayers = new ArrayList<DockableDisplayer>();
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();

    public DisplayerCollection(DockStation station, DisplayerFactory factory) {
        if (station == null) {
            throw new IllegalArgumentException("Station must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.station = station;
        this.factory = factory;
    }

    public DisplayerCollection(DockStation station, final DefaultDisplayerFactoryValue factory) {
        this(station, new DisplayerFactory(){

            public DockableDisplayer create(DockStation station, Dockable dockable, DockTitle title) {
                return factory.create(dockable, title);
            }
        });
    }

    public void addDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.add(listener);
        for (DockableDisplayer displayer : this) {
            displayer.addDockableDisplayerListener(listener);
        }
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.remove(listener);
        for (DockableDisplayer displayer : this) {
            displayer.removeDockableDisplayerListener(listener);
        }
    }

    @Override
    public Iterator<DockableDisplayer> iterator() {
        return this.displayers.iterator();
    }

    public DockableDisplayer fetch(Dockable dockable, DockTitle title) {
        DockableDisplayer displayer = this.factory.create(this.station, dockable, title);
        displayer.setDockable(dockable);
        displayer.setTitle(title);
        displayer.setStation(this.station);
        displayer.setController(this.controller);
        this.displayers.add(displayer);
        for (DockableDisplayerListener listener : this.listeners) {
            displayer.addDockableDisplayerListener(listener);
        }
        return displayer;
    }

    public void release(DockableDisplayer displayer) {
        for (DockableDisplayerListener listener : this.listeners) {
            displayer.removeDockableDisplayerListener(listener);
        }
        this.displayers.remove(displayer);
        displayer.setTitle(null);
        displayer.setDockable(null);
        displayer.setStation(null);
        displayer.setController(null);
    }

    public void setFactory(DisplayerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = factory;
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            for (DockableDisplayer displayer : this.displayers) {
                displayer.setController(controller);
            }
        }
    }
}

