/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.stream.StreamSource;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;

class OdfPackageStream
extends StreamSource {
    private OdfPackage pkg;
    private String name;
    private InputStream inputStream;
    private OutputStream outputStream = null;
    private boolean bClosed;

    public OdfPackageStream(OdfPackage pkg, String name) throws Exception {
        super(pkg.getInputStream(name), pkg.getBaseURI() + "/" + name);
        this.pkg = pkg;
        this.name = name;
    }

    public boolean isOutput() {
        return this.outputStream != null;
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.bClosed) {
            throw new IOException("stream already closed");
        }
        this.outputStream = this.pkg.insertOutputStream(this.name);
        return this.outputStream;
    }

    public OdfFileEntry geFileEntry() {
        return this.pkg.getFileEntry(this.name);
    }

    public String getName() {
        return this.name;
    }

    public OdfPackage getPackage() {
        return this.pkg;
    }

    void close() throws IOException {
        this.bClosed = true;
        this.inputStream.close();
        this.outputStream.close();
    }
}

