\name{as.represampling}
\alias{as.represampling}
\alias{as.represampling.list}
\alias{is.represampling}
\alias{print.represampling}
\alias{represampling}
\title{Resampling objects with repetition, i.e. sets of partitionings or boostrap samples}
\usage{
  as.represampling(object, ...)

  \method{as.represampling}{list} (object, ...)

  \method{print}{represampling} (x, ...)

  is.represampling(object)
}
\arguments{
  \item{object}{object of class \code{represampling}, or a
  list to be coerced to this class}

  \item{x}{object of class \code{represampling}}

  \item{...}{currently not used}
}
\value{
  \code{as.represampling} methods return an object of class
  \code{represampling} with the contents of \code{object}.
}
\description{
  Functions for handling \code{represampling} objects, i.e.
  \code{list}s of \code{\link{resampling}} objects.
}
\details{
  \code{represampling} objects are (names) lists of
  \code{\link{resampling}} objects. Such objects are
  typically created by \code{\link{partition.cv}},
  \code{\link{partition.kmeans}},
  \code{\link{represampling.disc.bootstrap}} and related
  functions.

  In \code{r}-repeated \code{k}-fold cross-validation, for
  example, the corresponding \code{represampling} object
  has length \code{r}, and each of its \code{r}
  \code{\link{resampling}} objects has length \code{k}.

  \code{as.resampling.list} coerces \code{object} to class
  \code{represampling} while coercing its elements to
  \code{\link{resampling}} objects. Some validity checks
  are performed.
}
\examples{
data(ecuador) # Muenchow et al. (2012), see ?ecuador
# Partitioning by elevation classes in 200 m steps:
fac = factor( as.character( floor( ecuador$dem / 300 ) ) )
summary(fac)
parti = as.resampling(fac)
# a list of lists specifying sets of training and test sets,
# using each factor at a time as the test set:
str(parti)
summary(parti)
}
\seealso{
  \code{\link{resampling}}, \code{\link{partition.cv}},
  \code{\link{partition.kmeans}},
  \code{\link{represampling.disc.bootstrap}}, etc.
}

