% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spflow-simulations.R
\name{spflow_sim}
\alias{spflow_sim}
\title{Simulate spatial interactions}
\usage{
spflow_sim(
  exogenous_variables,
  model_coefficients,
  inverted_filter,
  noise_sd,
  verbose = FALSE
)
}
\arguments{
\item{exogenous_variables}{A matrix of exogenous variables}

\item{model_coefficients}{A numeric vector of coefficients}

\item{inverted_filter}{A matrix that represents an inverted spatial filter matrix
(see \code{\link[=spatial_filter]{spatial_filter()}})}

\item{noise_sd}{A numeric which indicates the desired standard deviation of the simulated noise}

\item{verbose}{A logical whether signal to noise ration should be printed}
}
\value{
A vector of simulated flows
}
\description{
Simulate spatial interactions
}
\seealso{
Other spflow simulation functions: 
\code{\link{expand_flow_neighborhood}()},
\code{\link{spatial_filter}()}
}
\concept{spflow simulation functions}
\keyword{internal}
